/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.ejb.infinispan.ClientMappingsRegistryEntry;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ClientMappingsRegistryEntryMarshaller
implements ProtoStreamMarshaller<ClientMappingsRegistryEntry> {
    private static final int MEMBER_INDEX = 1;
    private static final int CLIENT_MAPPING_INDEX = 2;

    public ClientMappingsRegistryEntry readFrom(ProtoStreamReader reader) throws IOException {
        String memberName = null;
        LinkedList<ClientMapping> mappings = new LinkedList<ClientMapping>();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    memberName = reader.readString();
                    continue block4;
                }
                case 2: {
                    mappings.add((ClientMapping)reader.readObject(ClientMapping.class));
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new ClientMappingsRegistryEntry(memberName, (List<ClientMapping>)mappings);
    }

    public void writeTo(ProtoStreamWriter writer, ClientMappingsRegistryEntry entry) throws IOException {
        writer.writeString(1, (String)entry.getKey());
        for (ClientMapping mapping : (List)entry.getValue()) {
            writer.writeObject(2, (Object)mapping);
        }
    }

    public Class<? extends ClientMappingsRegistryEntry> getJavaClass() {
        return ClientMappingsRegistryEntry.class;
    }
}

