/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.ArrayList;
import java.util.List;
import org.jberet.job.model.Decision;
import org.jberet.job.model.Flow;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.job.model.Transition;

public final class FlowBuilder {
    private final String id;
    private String next;
    private final List<Transition> transitions = new ArrayList<Transition>();
    private final List<JobElement> jobElements = new ArrayList<JobElement>();

    public FlowBuilder(String id) {
        this.id = id;
    }

    public FlowBuilder next(String next) {
        this.next = next;
        return this;
    }

    public Transition.End<FlowBuilder> endOn(String exitStatusCondition) {
        Transition.End<FlowBuilder> end = new Transition.End<FlowBuilder>(exitStatusCondition);
        end.enclosingBuilder = this;
        this.transitions.add(end);
        return end;
    }

    public Transition.Fail<FlowBuilder> failOn(String exitStatusCondition) {
        Transition.Fail<FlowBuilder> fail = new Transition.Fail<FlowBuilder>(exitStatusCondition);
        fail.enclosingBuilder = this;
        this.transitions.add(fail);
        return fail;
    }

    public Transition.Stop<FlowBuilder> stopOn(String exitStatusCondition) {
        Transition.Stop<FlowBuilder> stop = new Transition.Stop<FlowBuilder>(exitStatusCondition, null);
        stop.enclosingBuilder = this;
        this.transitions.add(stop);
        return stop;
    }

    public Transition.Next<FlowBuilder> nextOn(String exitStatusCondition) {
        Transition.Next<FlowBuilder> nx = new Transition.Next<FlowBuilder>(exitStatusCondition);
        nx.enclosingBuilder = this;
        this.transitions.add(nx);
        return nx;
    }

    public FlowBuilder decision(Decision decision) {
        this.jobElements.add(decision);
        return this;
    }

    public FlowBuilder flow(Flow flow) {
        this.jobElements.add(flow);
        return this;
    }

    public FlowBuilder split(Split split) {
        this.jobElements.add(split);
        return this;
    }

    public FlowBuilder step(Step step) {
        this.jobElements.add(step);
        return this;
    }

    public Flow build() {
        Flow flow = new Flow(this.id);
        flow.next = this.next;
        flow.getTransitionElements().addAll(this.transitions);
        flow.jobElements = this.jobElements;
        return flow;
    }
}

