/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.cli.CommandContext;

public class HelpFormatter {
    public static void format(CommandContext ctx, BufferedReader reader) throws IOException {
        int width = ctx.getTerminalWidth();
        if (width <= 0) {
            width = 80;
        }
        String line = reader.readLine();
        while (line != null) {
            String next = reader.readLine();
            if (line.length() < width) {
                ctx.printLine(line);
            } else {
                int endLine;
                char[] offsetArr;
                int i;
                int offset = 0;
                if (next != null && !next.isEmpty()) {
                    for (i = 0; i < next.length(); ++i) {
                        if (Character.isWhitespace(next.charAt(i))) continue;
                        offset = i;
                        break;
                    }
                } else {
                    for (i = 0; i < line.length(); ++i) {
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        offset = i;
                        break;
                    }
                }
                if (offset == 0) {
                    offsetArr = null;
                } else {
                    offsetArr = new char[offset];
                    Arrays.fill(offsetArr, ' ');
                }
                for (endLine = width; endLine >= 0 && !Character.isWhitespace(line.charAt(endLine - 1)); --endLine) {
                }
                if (endLine < 0) {
                    endLine = width;
                }
                ctx.printLine(line.substring(0, endLine));
                int lineIndex = endLine;
                while (lineIndex < line.length()) {
                    int startLine;
                    endLine = Math.min(startLine + width - offset, line.length());
                    for (startLine = lineIndex; startLine < endLine && Character.isWhitespace(line.charAt(startLine)); ++startLine) {
                    }
                    if (startLine == endLine) {
                        startLine = lineIndex;
                    }
                    if ((endLine = startLine + width - offset) > line.length()) {
                        endLine = line.length();
                    } else {
                        while (endLine > startLine) {
                            if (Character.isWhitespace(line.charAt(endLine - 1))) {
                                --endLine;
                                break;
                            }
                            --endLine;
                        }
                        if (endLine == startLine) {
                            endLine = Math.min(startLine + width - offset, line.length());
                        }
                    }
                    lineIndex = endLine;
                    if (offsetArr != null) {
                        StringBuilder lineBuf = new StringBuilder();
                        lineBuf.append(offsetArr);
                        lineBuf.append(line.substring(startLine, endLine));
                        ctx.printLine(lineBuf.toString());
                        continue;
                    }
                    ctx.printLine(line.substring(startLine, endLine));
                }
            }
            line = next;
        }
    }
}

