/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowSubscribeIntercept;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowTimed<T>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final long maxSize;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;

    public FlowableWindowTimed(Flowable<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.maxSize = maxSize;
        this.bufferSize = bufferSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> downstream) {
        if (this.timespan == this.timeskip) {
            if (this.maxSize == Long.MAX_VALUE) {
                this.source.subscribe(new WindowExactUnboundedSubscriber(downstream, this.timespan, this.unit, this.scheduler, this.bufferSize));
                return;
            }
            this.source.subscribe(new WindowExactBoundedSubscriber(downstream, this.timespan, this.unit, this.scheduler, this.bufferSize, this.maxSize, this.restartTimerOnMaxSize));
            return;
        }
        this.source.subscribe(new WindowSkipSubscriber(downstream, this.timespan, this.timeskip, this.unit, this.scheduler.createWorker(), this.bufferSize));
    }

    static String missingBackpressureMessage(long index) {
        return "Unable to emit the next window (#" + index + ") due to lack of requests. Please make sure the downstream is ready to consume windows.";
    }

    static final class WindowSkipSubscriber<T>
    extends AbstractWindowSubscriber<T>
    implements Runnable {
        private static final long serialVersionUID = -7852870764194095894L;
        final long timeskip;
        final Scheduler.Worker worker;
        final List<UnicastProcessor<T>> windows;
        static final Object WINDOW_OPEN = new Object();
        static final Object WINDOW_CLOSE = new Object();

        WindowSkipSubscriber(Subscriber<? super Flowable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker worker, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.timeskip = timeskip;
            this.worker = worker;
            this.windows = new LinkedList<UnicastProcessor<T>>();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.emitted = 1L;
                    this.windowCount.getAndIncrement();
                    UnicastProcessor window = UnicastProcessor.create(this.bufferSize, this);
                    this.windows.add(window);
                    FlowableWindowSubscribeIntercept intercept = new FlowableWindowSubscribeIntercept(window);
                    this.downstream.onNext(intercept);
                    this.worker.schedule(new WindowBoundaryRunnable(this, false), this.timespan, this.unit);
                    this.worker.schedulePeriodically(new WindowBoundaryRunnable(this, true), this.timeskip, this.timeskip, this.unit);
                    if (intercept.tryAbandon()) {
                        window.onComplete();
                        this.windows.remove(window);
                    }
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.upstream.cancel();
                    this.downstream.onError((Throwable)new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(this.emitted)));
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                }
            }
        }

        @Override
        void cleanupResources() {
            this.worker.dispose();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimplePlainQueue queue = this.queue;
            Subscriber downstream = this.downstream;
            List<UnicastProcessor<T>> windows = this.windows;
            block0: while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (UnicastProcessor window : windows) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            for (UnicastProcessor window : windows) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        UnicastProcessor window;
                        if (o == WINDOW_OPEN) {
                            if (this.downstreamCancelled.get()) continue;
                            long emitted = this.emitted;
                            if (this.requested.get() != emitted) {
                                this.emitted = ++emitted;
                                this.windowCount.getAndIncrement();
                                window = UnicastProcessor.create(this.bufferSize, this);
                                windows.add(window);
                                FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(window);
                                downstream.onNext(intercept);
                                this.worker.schedule(new WindowBoundaryRunnable(this, false), this.timespan, this.unit);
                                if (!intercept.tryAbandon()) continue;
                                window.onComplete();
                                continue;
                            }
                            this.upstream.cancel();
                            MissingBackpressureException ex = new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(emitted));
                            for (UnicastProcessor<T> window2 : windows) {
                                window2.onError(ex);
                            }
                            downstream.onError((Throwable)ex);
                            this.cleanupResources();
                            this.upstreamCancelled = true;
                            continue;
                        }
                        if (o == WINDOW_CLOSE) {
                            if (windows.isEmpty()) continue;
                            windows.remove(0).onComplete();
                            continue;
                        }
                        Object item = o;
                        Iterator<UnicastProcessor<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block0;
                            window = iterator.next();
                            window.onNext(item);
                        }
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        void boundary(boolean isOpen) {
            this.queue.offer(isOpen ? WINDOW_OPEN : WINDOW_CLOSE);
            this.drain();
        }

        static final class WindowBoundaryRunnable
        implements Runnable {
            final WindowSkipSubscriber<?> parent;
            final boolean isOpen;

            WindowBoundaryRunnable(WindowSkipSubscriber<?> parent, boolean isOpen) {
                this.parent = parent;
                this.isOpen = isOpen;
            }

            @Override
            public void run() {
                this.parent.boundary(this.isOpen);
            }
        }
    }

    static final class WindowExactBoundedSubscriber<T>
    extends AbstractWindowSubscriber<T>
    implements Runnable {
        private static final long serialVersionUID = -6130475889925953722L;
        final Scheduler scheduler;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        final Scheduler.Worker worker;
        long count;
        UnicastProcessor<T> window;
        final SequentialDisposable timer;

        WindowExactBoundedSubscriber(Subscriber<? super Flowable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
            this.worker = restartTimerOnMaxSize ? scheduler.createWorker() : null;
            this.timer = new SequentialDisposable();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.emitted = 1L;
                    this.windowCount.getAndIncrement();
                    this.window = UnicastProcessor.create(this.bufferSize, this);
                    FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(this.window);
                    this.downstream.onNext(intercept);
                    WindowBoundaryRunnable boundaryTask = new WindowBoundaryRunnable(this, 1L);
                    if (this.restartTimerOnMaxSize) {
                        this.timer.replace(this.worker.schedulePeriodically(boundaryTask, this.timespan, this.timespan, this.unit));
                    } else {
                        this.timer.replace(this.scheduler.schedulePeriodicallyDirect(boundaryTask, this.timespan, this.timespan, this.unit));
                    }
                    if (intercept.tryAbandon()) {
                        this.window.onComplete();
                    }
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.upstream.cancel();
                    this.downstream.onError((Throwable)new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(this.emitted)));
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                }
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
            Scheduler.Worker w = this.worker;
            if (w != null) {
                w.dispose();
            }
        }

        void boundary(WindowBoundaryRunnable sender) {
            this.queue.offer(sender);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimplePlainQueue queue = this.queue;
            Subscriber downstream = this.downstream;
            UnicastProcessor window = this.window;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o instanceof WindowBoundaryRunnable) {
                            WindowBoundaryRunnable boundary = (WindowBoundaryRunnable)o;
                            if (boundary.index != this.emitted && this.restartTimerOnMaxSize) continue;
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o;
                        window.onNext(item);
                        long count = this.count + 1L;
                        if (count == this.maxSize) {
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        this.count = count;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        UnicastProcessor<T> createNewWindow(UnicastProcessor<T> window) {
            if (window != null) {
                window.onComplete();
                window = null;
            }
            if (this.downstreamCancelled.get()) {
                this.cleanupResources();
            } else {
                long emitted = this.emitted;
                if (this.requested.get() == emitted) {
                    this.upstream.cancel();
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                    this.downstream.onError((Throwable)new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(emitted)));
                } else {
                    this.emitted = ++emitted;
                    this.windowCount.getAndIncrement();
                    window = UnicastProcessor.create(this.bufferSize, this);
                    this.window = window;
                    FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(window);
                    this.downstream.onNext(intercept);
                    if (this.restartTimerOnMaxSize) {
                        this.timer.update(this.worker.schedulePeriodically(new WindowBoundaryRunnable(this, emitted), this.timespan, this.timespan, this.unit));
                    }
                    if (intercept.tryAbandon()) {
                        window.onComplete();
                    }
                }
            }
            return window;
        }

        static final class WindowBoundaryRunnable
        implements Runnable {
            final WindowExactBoundedSubscriber<?> parent;
            final long index;

            WindowBoundaryRunnable(WindowExactBoundedSubscriber<?> parent, long index) {
                this.parent = parent;
                this.index = index;
            }

            @Override
            public void run() {
                this.parent.boundary(this);
            }
        }
    }

    static final class WindowExactUnboundedSubscriber<T>
    extends AbstractWindowSubscriber<T>
    implements Runnable {
        private static final long serialVersionUID = 1155822639622580836L;
        final Scheduler scheduler;
        UnicastProcessor<T> window;
        final SequentialDisposable timer;
        static final Object NEXT_WINDOW = new Object();
        final Runnable windowRunnable;

        WindowExactUnboundedSubscriber(Subscriber<? super Flowable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.timer = new SequentialDisposable();
            this.windowRunnable = new WindowRunnable();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.windowCount.getAndIncrement();
                    this.window = UnicastProcessor.create(this.bufferSize, this.windowRunnable);
                    this.emitted = 1L;
                    FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(this.window);
                    this.downstream.onNext(intercept);
                    this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit));
                    if (intercept.tryAbandon()) {
                        this.window.onComplete();
                    }
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.upstream.cancel();
                    this.downstream.onError((Throwable)new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(this.emitted)));
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                }
            }
        }

        @Override
        public void run() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SimplePlainQueue queue = this.queue;
            Subscriber downstream = this.downstream;
            UnicastProcessor window = this.window;
            int missed = 1;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o == NEXT_WINDOW) {
                            if (window != null) {
                                window.onComplete();
                                window = null;
                                this.window = null;
                            }
                            if (this.downstreamCancelled.get()) {
                                this.timer.dispose();
                                continue;
                            }
                            if (this.requested.get() == this.emitted) {
                                this.upstream.cancel();
                                this.cleanupResources();
                                this.upstreamCancelled = true;
                                downstream.onError((Throwable)new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(this.emitted)));
                                continue;
                            }
                            ++this.emitted;
                            this.windowCount.getAndIncrement();
                            window = UnicastProcessor.create(this.bufferSize, this.windowRunnable);
                            this.window = window;
                            FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(window);
                            downstream.onNext(intercept);
                            if (!intercept.tryAbandon()) continue;
                            window.onComplete();
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o;
                        window.onNext(item);
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
        }

        final class WindowRunnable
        implements Runnable {
            WindowRunnable() {
            }

            @Override
            public void run() {
                WindowExactUnboundedSubscriber.this.windowDone();
            }
        }
    }

    static abstract class AbstractWindowSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 5724293814035355511L;
        final Subscriber<? super Flowable<T>> downstream;
        final SimplePlainQueue<Object> queue;
        final long timespan;
        final TimeUnit unit;
        final int bufferSize;
        final AtomicLong requested;
        long emitted;
        volatile boolean done;
        Throwable error;
        Subscription upstream;
        final AtomicBoolean downstreamCancelled;
        volatile boolean upstreamCancelled;
        final AtomicInteger windowCount;

        AbstractWindowSubscriber(Subscriber<? super Flowable<T>> downstream, long timespan, TimeUnit unit, int bufferSize) {
            this.downstream = downstream;
            this.queue = new MpscLinkedQueue<Object>();
            this.timespan = timespan;
            this.unit = unit;
            this.bufferSize = bufferSize;
            this.requested = new AtomicLong();
            this.downstreamCancelled = new AtomicBoolean();
            this.windowCount = new AtomicInteger(1);
        }

        @Override
        public final void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                this.createFirstWindow();
            }
        }

        abstract void createFirstWindow();

        public final void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public final void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        public final void cancel() {
            if (this.downstreamCancelled.compareAndSet(false, true)) {
                this.windowDone();
            }
        }

        final void windowDone() {
            if (this.windowCount.decrementAndGet() == 0) {
                this.cleanupResources();
                this.upstream.cancel();
                this.upstreamCancelled = true;
                this.drain();
            }
        }

        abstract void cleanupResources();

        abstract void drain();
    }
}

