/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.activemq.artemis.utils.Preconditions;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class NettyReadable
implements ReadableBuffer {
    private static final Charset Charset_UTF8 = Charset.forName("UTF-8");
    private final ByteBuf buffer;

    public NettyReadable(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer);
        this.buffer = buffer;
    }

    public ByteBuf getByteBuf() {
        return this.buffer;
    }

    public byte get() {
        return this.buffer.readByte();
    }

    public int getInt() {
        return this.buffer.readInt();
    }

    public long getLong() {
        return this.buffer.readLong();
    }

    public short getShort() {
        return this.buffer.readShort();
    }

    public float getFloat() {
        return this.buffer.readFloat();
    }

    public double getDouble() {
        return this.buffer.readDouble();
    }

    public ReadableBuffer get(byte[] data, int offset, int length) {
        this.buffer.readBytes(data, offset, length);
        return this;
    }

    public ReadableBuffer get(byte[] data) {
        this.buffer.readBytes(data);
        return this;
    }

    public ReadableBuffer position(int position) {
        this.buffer.readerIndex(position);
        return this;
    }

    public ReadableBuffer slice() {
        return new NettyReadable(this.buffer.slice());
    }

    public ReadableBuffer flip() {
        this.buffer.setIndex(0, this.buffer.readerIndex());
        return this;
    }

    public ReadableBuffer limit(int limit) {
        this.buffer.writerIndex(limit);
        return this;
    }

    public int limit() {
        return this.buffer.writerIndex();
    }

    public int remaining() {
        return this.buffer.readableBytes();
    }

    public int position() {
        return this.buffer.readerIndex();
    }

    public boolean hasRemaining() {
        return this.buffer.readableBytes() > 0;
    }

    public ReadableBuffer duplicate() {
        return new NettyReadable(this.buffer.duplicate());
    }

    public ByteBuffer byteBuffer() {
        return this.buffer.nioBuffer(0, this.buffer.writerIndex());
    }

    public String readUTF8() {
        return this.buffer.toString(Charset_UTF8);
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ReadableBuffer clear() {
        this.buffer.setIndex(0, this.buffer.capacity());
        return this;
    }

    public ReadableBuffer reclaimRead() {
        return this;
    }

    public byte get(int index) {
        return this.buffer.getByte(index);
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public ReadableBuffer mark() {
        this.buffer.markReaderIndex();
        return this;
    }

    public String readString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.buffer.toString(decoder.charset());
    }

    public ReadableBuffer reset() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public ReadableBuffer rewind() {
        this.buffer.setIndex(0, this.buffer.writerIndex());
        return this;
    }

    public ReadableBuffer get(WritableBuffer target) {
        int start = target.position();
        if (this.buffer.hasArray()) {
            target.put(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.readerIndex(), this.buffer.readableBytes());
        } else {
            target.put(this.buffer.nioBuffer());
        }
        int written = target.position() - start;
        this.buffer.readerIndex(this.buffer.readerIndex() + written);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReadableBuffer)) {
            return false;
        }
        ReadableBuffer readable = (ReadableBuffer)other;
        if (this.remaining() != readable.remaining()) {
            return false;
        }
        return this.buffer.nioBuffer().equals(readable.byteBuffer());
    }
}

