/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.ConfiguredProvider;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.RegistryProvider;

public final class ServiceRegistry
implements Contextual<ServiceRegistry> {
    private static final ContextManager<ServiceRegistry> CONTEXT_MANAGER = new ContextManager(ServiceRegistry.class, "org.wildfly.discovery.registration");
    private final RegistryProvider registryProvider;

    private ServiceRegistry(RegistryProvider registryProvider) {
        this.registryProvider = registryProvider;
    }

    public ContextManager<ServiceRegistry> getInstanceContextManager() {
        return ServiceRegistry.getContextManager();
    }

    public static ContextManager<ServiceRegistry> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public static ServiceRegistry create(RegistryProvider registryProvider) {
        Assert.checkNotNullParam((String)"registryProvider", (Object)registryProvider);
        return new ServiceRegistry(registryProvider);
    }

    public ServiceRegistration registerService(ServiceURL serviceURL) {
        Assert.checkNotNullParam((String)"serviceURL", (Object)serviceURL);
        return this.registryProvider.registerService(serviceURL);
    }

    public ServiceRegistration registerServices(ServiceURL ... serviceURLs) {
        Assert.checkNotNullParam((String)"serviceURLs", (Object)serviceURLs);
        int length = serviceURLs.length;
        for (int i = 0; i < length; ++i) {
            Assert.checkNotNullArrayParam((String)"serviceURLs", (int)i, (Object)serviceURLs[i]);
        }
        return this.registryProvider.registerServices(serviceURLs);
    }

    static {
        CONTEXT_MANAGER.setGlobalDefaultSupplier(() -> ServiceRegistry.create(ConfiguredProvider.INSTANCE));
    }
}

