/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.bulkhead;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadBase;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadEvents;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadLogger;
import java.util.concurrent.Semaphore;

public class SemaphoreBulkhead<V>
extends BulkheadBase<V> {
    private final Semaphore semaphore;

    public SemaphoreBulkhead(FaultToleranceStrategy<V> delegate, String description, int size) {
        super(description, delegate);
        this.semaphore = new Semaphore(size);
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        BulkheadLogger.LOG.trace("SemaphoreBulkhead started");
        try {
            V v = this.doApply(ctx);
            return v;
        }
        finally {
            BulkheadLogger.LOG.trace("SemaphoreBulkhead finished");
        }
    }

    private V doApply(InvocationContext<V> ctx) throws Exception {
        if (this.semaphore.tryAcquire()) {
            BulkheadLogger.LOG.trace("Semaphore acquired, accepting task into bulkhead");
            ctx.fireEvent(BulkheadEvents.DecisionMade.ACCEPTED);
            ctx.fireEvent(BulkheadEvents.StartedRunning.INSTANCE);
            try {
                V v = this.delegate.apply(ctx);
                return v;
            }
            finally {
                this.semaphore.release();
                BulkheadLogger.LOG.trace("Semaphore released, task leaving bulkhead");
                ctx.fireEvent(BulkheadEvents.FinishedRunning.INSTANCE);
            }
        }
        BulkheadLogger.LOG.trace("Semaphore not acquired, rejecting task from bulkhead");
        ctx.fireEvent(BulkheadEvents.DecisionMade.REJECTED);
        throw this.bulkheadRejected();
    }
}

