/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.OverallInterfaceCriteria;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class NetworkInterfaceService
implements Service<NetworkInterfaceBinding> {
    private static ServerLogger log = ServerLogger.NETWORK_LOGGER;
    @Deprecated
    public static final ServiceName JBOSS_NETWORK_INTERFACE = ServiceName.JBOSS.append(new String[]{"network"});
    private static final String IPV4_ANYLOCAL = "0.0.0.0";
    private static final String IPV6_ANYLOCAL = "::";
    private NetworkInterfaceBinding interfaceBinding;
    private final String name;
    private final boolean anyLocal;
    private final OverallInterfaceCriteria criteria;

    public static Service<NetworkInterfaceBinding> create(String name, ParsedInterfaceCriteria criteria) {
        return new NetworkInterfaceService(name, criteria.isAnyLocal(), criteria.getCriteria());
    }

    public NetworkInterfaceService(String name, boolean anyLocal, Set<InterfaceCriteria> criteria) {
        this.name = name;
        this.anyLocal = anyLocal;
        this.criteria = new OverallInterfaceCriteria(name, criteria);
    }

    public synchronized void start(StartContext arg0) throws StartException {
        log.debug("Starting NetworkInterfaceService\n");
        try {
            this.interfaceBinding = NetworkInterfaceService.createBinding(this.anyLocal, this.criteria);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (this.interfaceBinding == null) {
            throw ServerLogger.ROOT_LOGGER.failedToResolveInterface(this.name);
        }
        log.debugf("NetworkInterfaceService matched interface binding: %s\n", this.interfaceBinding);
    }

    public static NetworkInterfaceBinding createBinding(ParsedInterfaceCriteria criteria) throws SocketException, UnknownHostException {
        return NetworkInterfaceService.createBinding(criteria.isAnyLocal(), new OverallInterfaceCriteria(null, criteria.getCriteria()));
    }

    static NetworkInterfaceBinding createBinding(boolean anyLocal, OverallInterfaceCriteria criteria) throws SocketException, UnknownHostException {
        if (anyLocal) {
            return NetworkInterfaceService.getNetworkInterfaceBinding(NetworkInterfaceService.isUseIPv4Stack() ? IPV4_ANYLOCAL : IPV6_ANYLOCAL);
        }
        return NetworkInterfaceService.resolveInterface(criteria);
    }

    public synchronized void stop(StopContext arg0) {
        this.interfaceBinding = null;
    }

    public synchronized NetworkInterfaceBinding getValue() throws IllegalStateException {
        NetworkInterfaceBinding binding = this.interfaceBinding;
        if (binding == null) {
            throw new IllegalStateException();
        }
        return binding;
    }

    private static NetworkInterfaceBinding resolveInterface(OverallInterfaceCriteria criteria) throws SocketException {
        NetworkInterfaceBinding result = null;
        HashMap<NetworkInterface, Set<InetAddress>> candidates = new HashMap<NetworkInterface, Set<InetAddress>>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterfaceService.storeAddresses(networkInterfaces.nextElement(), candidates);
        }
        Map acceptable = criteria.getAcceptableAddresses(candidates);
        if (acceptable.size() == 1 && ((Set)acceptable.values().iterator().next()).size() == 1) {
            Map.Entry entry = acceptable.entrySet().iterator().next();
            InetAddress addr = (InetAddress)((Set)entry.getValue()).iterator().next();
            result = new NetworkInterfaceBinding(Collections.singleton(entry.getKey()), addr);
        }
        return result;
    }

    private static void storeAddresses(NetworkInterface networkInterface, Map<NetworkInterface, Set<InetAddress>> candidates) {
        Enumeration<InetAddress> interfaceAddresses = networkInterface.getInetAddresses();
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        candidates.put(networkInterface, addresses);
        while (interfaceAddresses.hasMoreElements()) {
            addresses.add(interfaceAddresses.nextElement());
        }
        Enumeration<NetworkInterface> subInterfaces = networkInterface.getSubInterfaces();
        while (subInterfaces.hasMoreElements()) {
            NetworkInterfaceService.storeAddresses(subInterfaces.nextElement(), candidates);
        }
    }

    static NetworkInterfaceBinding getNetworkInterfaceBinding(String addr) throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getByName(addr);
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            interfaces.add(networkInterfaces.nextElement());
        }
        return new NetworkInterfaceBinding(interfaces, address);
    }

    private static boolean isUseIPv4Stack() {
        boolean isPreferIPv6Stack = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"java.net.preferIPv6Addresses", (String)"false"));
        boolean isPreferIPv4Stack = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"java.net.preferIPv4Stack", (String)"false"));
        return !(InetAddress.getLoopbackAddress() instanceof Inet6Address) || !isPreferIPv6Stack && isPreferIPv4Stack;
    }
}

