/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.service.CreateDestroyService;
import org.jboss.as.service.DelegatingSupplier;
import org.jboss.as.service.MBeanRegistrationService;
import org.jboss.as.service.ReflectionUtils;
import org.jboss.as.service.ServiceNameFactory;
import org.jboss.as.service.StartStopService;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

final class MBeanServices {
    private static final String CREATE_METHOD_NAME = "create";
    private static final String DESTROY_METHOD_NAME = "destroy";
    private static final String START_METHOD_NAME = "start";
    private static final String STOP_METHOD_NAME = "stop";
    private final CreateDestroyService createDestroyService;
    private final ServiceBuilder<?> createDestroyServiceBuilder;
    private final ServiceBuilder<?> startStopServiceBuilder;
    private final ServiceBuilder<?> registerUnregisterServiceBuilder;
    private boolean installed;

    MBeanServices(String mBeanName, Object mBeanInstance, List<ClassReflectionIndex> mBeanClassHierarchy, ServiceTarget target, ServiceComponentInstantiator componentInstantiator, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader, ServiceName mbeanServerServiceName) {
        if (mBeanClassHierarchy == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("mBeanClassHierarchy");
        }
        if (mBeanInstance == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("mBeanInstance");
        }
        if (target == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("target");
        }
        if (mbeanServerServiceName == null) {
            throw SarLogger.ROOT_LOGGER.nullVar("mbeanServerServiceName");
        }
        Method createMethod = ReflectionUtils.getNoArgMethod(mBeanClassHierarchy, CREATE_METHOD_NAME);
        Method destroyMethod = ReflectionUtils.getNoArgMethod(mBeanClassHierarchy, DESTROY_METHOD_NAME);
        ServiceName createDestroyServiceName = ServiceNameFactory.newCreateDestroy(mBeanName);
        this.createDestroyServiceBuilder = target.addService(createDestroyServiceName);
        Consumer mBeanInstanceConsumer = this.createDestroyServiceBuilder.provides(new ServiceName[]{createDestroyServiceName});
        Supplier executorSupplier = this.createDestroyServiceBuilder.requires(AbstractControllerService.EXECUTOR_CAPABILITY.getCapabilityServiceName());
        this.createDestroyService = new CreateDestroyService(mBeanInstance, createMethod, destroyMethod, componentInstantiator, setupActions, mbeanContextClassLoader, mBeanInstanceConsumer, executorSupplier);
        this.createDestroyServiceBuilder.setInstance((Service)this.createDestroyService);
        if (componentInstantiator != null) {
            this.createDestroyServiceBuilder.requires(componentInstantiator.getComponentStartServiceName());
        }
        Method startMethod = ReflectionUtils.getNoArgMethod(mBeanClassHierarchy, START_METHOD_NAME);
        Method stopMethod = ReflectionUtils.getNoArgMethod(mBeanClassHierarchy, STOP_METHOD_NAME);
        ServiceName startStopServiceName = ServiceNameFactory.newStartStop(mBeanName);
        this.startStopServiceBuilder = target.addService(startStopServiceName);
        mBeanInstanceConsumer = this.startStopServiceBuilder.provides(new ServiceName[]{startStopServiceName});
        executorSupplier = this.startStopServiceBuilder.requires(AbstractControllerService.EXECUTOR_CAPABILITY.getCapabilityServiceName());
        StartStopService startStopService = new StartStopService(mBeanInstance, startMethod, stopMethod, setupActions, mbeanContextClassLoader, mBeanInstanceConsumer, executorSupplier);
        this.startStopServiceBuilder.setInstance((Service)startStopService);
        this.startStopServiceBuilder.requires(createDestroyServiceName);
        ServiceName registerUnregisterServiceName = ServiceNameFactory.newRegisterUnregister(mBeanName);
        this.registerUnregisterServiceBuilder = target.addService(registerUnregisterServiceName);
        this.registerUnregisterServiceBuilder.provides(new ServiceName[]{registerUnregisterServiceName, MBeanRegistrationService.SERVICE_NAME.append(new String[]{mBeanName})});
        Supplier mBeanServerSupplier = this.registerUnregisterServiceBuilder.requires(mbeanServerServiceName);
        Supplier objectSupplier = this.registerUnregisterServiceBuilder.requires(startStopServiceName);
        this.registerUnregisterServiceBuilder.setInstance((Service)new MBeanRegistrationService(mBeanName, setupActions, mBeanServerSupplier, objectSupplier));
        for (SetupAction action : setupActions) {
            for (ServiceName dependency : action.dependencies()) {
                this.startStopServiceBuilder.requires(dependency);
                this.createDestroyServiceBuilder.requires(dependency);
            }
        }
    }

    void addDependency(String dependencyMBeanName) {
        this.assertState();
        ServiceName injectedMBeanCreateDestroyServiceName = ServiceNameFactory.newCreateDestroy(dependencyMBeanName);
        this.createDestroyServiceBuilder.requires(injectedMBeanCreateDestroyServiceName);
        ServiceName injectedMBeanStartStopServiceName = ServiceNameFactory.newStartStop(dependencyMBeanName);
        this.startStopServiceBuilder.requires(injectedMBeanStartStopServiceName);
        ServiceName injectedMBeanRegisterUnregisterServiceName = ServiceNameFactory.newRegisterUnregister(dependencyMBeanName);
        this.registerUnregisterServiceBuilder.requires(injectedMBeanRegisterUnregisterServiceName);
    }

    void addAttribute(String attributeMBeanName, Method setter, DelegatingSupplier propertySupplier) {
        this.assertState();
        ServiceName injectedMBeanCreateDestroyServiceName = ServiceNameFactory.newCreateDestroy(attributeMBeanName);
        Supplier injectedMBeanSupplier = this.createDestroyServiceBuilder.requires(injectedMBeanCreateDestroyServiceName);
        propertySupplier.setObjectSupplier(injectedMBeanSupplier);
        this.createDestroyService.inject(setter, propertySupplier);
        ServiceName injectedMBeanStartStopServiceName = ServiceNameFactory.newStartStop(attributeMBeanName);
        this.startStopServiceBuilder.requires(injectedMBeanStartStopServiceName);
    }

    void addValue(Method setter, Supplier<Object> objectSupplier) {
        this.assertState();
        this.createDestroyService.inject(setter, objectSupplier);
    }

    void install() {
        this.assertState();
        this.createDestroyServiceBuilder.install();
        this.startStopServiceBuilder.install();
        this.registerUnregisterServiceBuilder.install();
        this.installed = true;
    }

    private void assertState() {
        if (this.installed) {
            throw new IllegalStateException();
        }
    }
}

