/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.bug986;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlSchemaType;
import org.xml.sax.ErrorHandler;

public class Bug986Plugin {
    private static final Logger LOG = Logger.getLogger(Bug986Plugin.class.getName());
    final Plugin plugin;

    public Bug986Plugin(Plugin p) {
        this.plugin = p;
    }

    public String getOptionName() {
        return "Xbug986";
    }

    public String getUsage() {
        return "  -Xbug986             : Activate plugin remove XmlSchemaType(anySimpleType) from fields that shouldn't have it.";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.fine("Running Bug986Plugin plugin.");
        for (ClassOutline classOutline : outline.getClasses()) {
            Map fields = classOutline.implClass.fields();
            for (JFieldVar field : fields.values()) {
                List<JAnnotationUse> annotations = this.getAnnotations(field);
                ArrayList<JAnnotationUse> toRemove = new ArrayList<JAnnotationUse>();
                for (JAnnotationUse j : annotations) {
                    if (!XmlSchemaType.class.getName().equals(this.getAnnotationClass(j).fullName())) continue;
                    JAnnotationValue st = this.getAnnotationMember(j, "name");
                    StringWriter sw = new StringWriter();
                    st.generate(new JFormatter((Writer)sw));
                    if (!"\"anySimpleType\"".equals(sw.toString())) continue;
                    if (field.type().fullName().startsWith("java.util.List")) {
                        if (field.type().fullName().contains("<java.lang.String>")) continue;
                        toRemove.add(j);
                        continue;
                    }
                    if ("java.lang.String".equals(field.type().fullName())) continue;
                    toRemove.add(j);
                }
                for (JAnnotationUse j : toRemove) {
                    annotations.remove(j);
                }
            }
        }
        return true;
    }

    private JAnnotationValue getAnnotationMember(JAnnotationUse ju, String name) {
        try {
            Field f = JAnnotationUse.class.getDeclaredField("memberValues");
            f.setAccessible(true);
            Map memberValues = (Map)f.get(ju);
            if (memberValues == null) {
                return null;
            }
            return (JAnnotationValue)memberValues.get(name);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private JClass getAnnotationClass(JAnnotationUse ju) {
        try {
            Field f = JAnnotationUse.class.getDeclaredField("clazz");
            f.setAccessible(true);
            return (JClass)f.get(ju);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private List<JAnnotationUse> getAnnotations(JFieldVar field) {
        try {
            Field f = JVar.class.getDeclaredField("annotations");
            f.setAccessible(true);
            List<JAnnotationUse> anns = (List<JAnnotationUse>)f.get(field);
            if (anns == null) {
                anns = Collections.emptyList();
            }
            return anns;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Collections.emptyList();
        }
    }
}

