/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.operators.multi.multicast.MultiReferenceCount;
import io.smallrye.mutiny.subscription.Cancellable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ConnectableMultiConnection
implements Runnable,
Consumer<Cancellable> {
    private static final Cancellable CANCELLED = () -> {};
    private final MultiReferenceCount<?> parent;
    private final AtomicReference<Cancellable> onCancellation = new AtomicReference();
    private Cancellable timer;
    private long subscriberCount;
    private boolean connected;

    ConnectableMultiConnection(MultiReferenceCount<?> parent) {
        this.parent = parent;
    }

    @Override
    public void run() {
        this.parent.timeout(this);
    }

    @Override
    public void accept(Cancellable action) {
        Cancellable current;
        do {
            if ((current = this.onCancellation.get()) != CANCELLED || action == null) continue;
            action.cancel();
        } while (!this.onCancellation.compareAndSet(current, action));
    }

    public synchronized boolean shouldConnectAfterIncrement(int toBeReached) {
        ++this.subscriberCount;
        if (!this.connected && this.subscriberCount == (long)toBeReached) {
            this.connected = true;
            return true;
        }
        return false;
    }

    public long getSubscriberCount() {
        return this.subscriberCount;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimerIf0() {
        boolean cancel;
        ConnectableMultiConnection connectableMultiConnection = this;
        synchronized (connectableMultiConnection) {
            cancel = this.subscriberCount == 0L && this.timer != null;
        }
        if (cancel) {
            this.timer.cancel();
        }
    }

    public void cancel() {
        Cancellable current = this.onCancellation.getAndSet(CANCELLED);
        if (current != null && current != CANCELLED) {
            current.cancel();
        }
    }

    synchronized boolean decrementAndReached0() {
        if (this.subscriberCount == 1L) {
            this.subscriberCount = 0L;
            return true;
        }
        --this.subscriberCount;
        return false;
    }

    synchronized long decrement() {
        --this.subscriberCount;
        return this.subscriberCount;
    }

    synchronized void setTimer(Cancellable cancellable) {
        if (this.timer != null && this.timer != CANCELLED) {
            this.timer.cancel();
        }
        this.timer = cancellable;
    }
}

