/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.smallrye.common.annotation.Experimental;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;

@Experimental(value="Tracer metadata is a SmallRye specific feature for integrating with OpenTelemetry")
public class TracingMetadata {
    private static final TracingMetadata EMPTY = new TracingMetadata(null);
    private final Context currentSpanContext;
    private final Context previousSpanContext;

    private TracingMetadata(Context spanContext) {
        this(spanContext, null);
    }

    private TracingMetadata(Context spanContext, Context previousSpanContext) {
        this.currentSpanContext = spanContext;
        this.previousSpanContext = previousSpanContext;
    }

    public static TracingMetadata empty() {
        return EMPTY;
    }

    public static Optional<TracingMetadata> fromMessage(Message<?> message) {
        return message.getMetadata(TracingMetadata.class);
    }

    public static TracingMetadata withPrevious(Context previousContext) {
        if (previousContext != null) {
            return new TracingMetadata(null, previousContext);
        }
        return EMPTY;
    }

    public static TracingMetadata withCurrent(Context currentContext) {
        if (currentContext != null) {
            return new TracingMetadata(currentContext);
        }
        return EMPTY;
    }

    public TracingMetadata withSpan(Span span) {
        if (span != null) {
            return new TracingMetadata(Context.root().with((ImplicitContextKeyed)span), this.previousSpanContext);
        }
        return this;
    }

    public Context getCurrentContext() {
        return this.currentSpanContext;
    }

    public Context getPreviousContext() {
        return this.previousSpanContext;
    }
}

