/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.concurrent.TimeUnit;
import org.hornetq.utils.TokenBucketLimiter;

public class TokenBucketLimiterImpl
implements TokenBucketLimiter {
    private final int rate;
    private final long window;
    private final boolean spin;
    private volatile long last;
    private volatile int tokens;

    public TokenBucketLimiterImpl(int rate, boolean spin) {
        this(rate, spin, TimeUnit.SECONDS, 1);
    }

    public TokenBucketLimiterImpl(int rate, boolean spin, TimeUnit unit, int unitAmount) {
        this.rate = rate;
        this.spin = spin;
        this.window = unit.toMillis(unitAmount);
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public boolean isSpin() {
        return this.spin;
    }

    @Override
    public void limit() {
        while (!this.check()) {
            if (this.spin) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    private boolean check() {
        long diff;
        long now = System.currentTimeMillis();
        if (this.last == 0L) {
            this.last = now;
        }
        if ((diff = now - this.last) >= this.window) {
            this.last = System.currentTimeMillis();
            this.tokens = this.rate;
        }
        if (this.tokens > 0) {
            --this.tokens;
            return true;
        }
        return false;
    }
}

