/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;

interface ProtoStreamReaderContext
extends ProtoStreamOperation.Context,
AutoCloseable {
    public static final ThreadLocal<ProtoStreamReaderContext> INSTANCE = new ThreadLocal<ProtoStreamReaderContext>(){

        @Override
        protected ProtoStreamReaderContext initialValue() {
            return new ProtoStreamReaderContext(){
                private final Map<Object, Boolean> objects = new IdentityHashMap<Object, Boolean>(64);
                private final List<Object> references = new ArrayList<Object>();

                @Override
                public void addReference(Object object) {
                    if (this.objects.putIfAbsent(object, Boolean.TRUE) == null) {
                        this.references.add(object);
                    }
                }

                @Override
                public Object fromReference(int referenceId) {
                    return this.references.get(referenceId);
                }
            };
        }
    };

    public Object fromReference(int var1);

    @Override
    default public void close() {
        INSTANCE.remove();
    }
}

