/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;

public class ConsoleAppender
extends WriterAppender {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    protected String target = "System.out";
    private boolean follow = false;

    public ConsoleAppender() {
    }

    public ConsoleAppender(Layout layout) {
        this(layout, SYSTEM_OUT);
    }

    public ConsoleAppender(Layout layout, String target) {
        this.setLayout(layout);
        this.setTarget(target);
        this.activateOptions();
    }

    public void setTarget(String value) {
        String v = value.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(v)) {
            this.target = SYSTEM_OUT;
        } else if (SYSTEM_ERR.equalsIgnoreCase(v)) {
            this.target = SYSTEM_ERR;
        } else {
            this.targetWarn(value);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public final void setFollow(boolean newValue) {
        this.follow = newValue;
    }

    public final boolean getFollow() {
        return this.follow;
    }

    void targetWarn(String val) {
        LogLog.warn("[" + val + "] should be System.out or System.err.");
        LogLog.warn("Using previously set target, System.out by default.");
    }

    @Override
    public void activateOptions() {
        if (this.target.equals(SYSTEM_ERR)) {
            this.setWriter(this.createWriter(new SystemErrStream()));
        } else {
            this.setWriter(this.createWriter(new SystemOutStream()));
        }
        super.activateOptions();
    }

    @Override
    protected final void closeWriter() {
        super.closeWriter();
    }

    private static PrintStream createPrintStream(FileDescriptor fd) {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(fd){

            @Override
            public void close() {
            }
        }, 128));
    }

    static /* synthetic */ PrintStream access$000(FileDescriptor x0) {
        return ConsoleAppender.createPrintStream(x0);
    }

    private static class SystemOutStream
    extends OutputStream {
        private final PrintStream out = ConsoleAppender.access$000(FileDescriptor.out);

        @Override
        public void close() {
            this.out.close();
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        private final PrintStream err = ConsoleAppender.access$000(FileDescriptor.err);

        @Override
        public void close() {
            this.err.close();
        }

        @Override
        public void flush() {
            this.err.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.err.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.err.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.err.write(b);
        }
    }
}

