/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.BinaryExternalizer;
import org.wildfly.clustering.marshalling.spi.EnumExternalizer;
import org.wildfly.clustering.marshalling.spi.ExternalizerProvider;
import org.wildfly.clustering.marshalling.spi.IntExternalizer;
import org.wildfly.clustering.marshalling.spi.LongExternalizer;
import org.wildfly.clustering.marshalling.spi.StringExternalizer;
import org.wildfly.clustering.marshalling.spi.time.DurationExternalizer;
import org.wildfly.clustering.marshalling.spi.time.InstantExternalizer;
import org.wildfly.clustering.marshalling.spi.time.MonthDayExternalizer;
import org.wildfly.clustering.marshalling.spi.time.PeriodExternalizer;
import org.wildfly.clustering.marshalling.spi.time.YearMonthExternalizer;

public enum TimeExternalizerProvider implements ExternalizerProvider
{
    DAY_OF_WEEK(new EnumExternalizer<DayOfWeek>(DayOfWeek.class)),
    DURATION(new DurationExternalizer()),
    INSTANT(new InstantExternalizer()),
    LOCAL_DATE(new LongExternalizer<LocalDate>(LocalDate.class, LocalDate::ofEpochDay, LocalDate::toEpochDay)),
    LOCAL_TIME(new LongExternalizer<LocalTime>(LocalTime.class, LocalTime::ofNanoOfDay, LocalTime::toNanoOfDay)),
    LOCAL_DATE_TIME(new BinaryExternalizer<LocalDateTime, LocalDate, LocalTime>(LocalDateTime.class, LOCAL_DATE.cast(LocalDate.class), LOCAL_TIME.cast(LocalTime.class), LocalDateTime::toLocalDate, LocalDateTime::toLocalTime, LocalDateTime::of)),
    MONTH(new EnumExternalizer<Month>(Month.class)),
    MONTH_DAY(new MonthDayExternalizer()),
    PERIOD(new PeriodExternalizer()),
    YEAR(new IntExternalizer<Year>(Year.class, Year::of, Year::getValue)),
    YEAR_MONTH(new YearMonthExternalizer()),
    ZONE_ID(new StringExternalizer<ZoneId>(ZoneId.class, ZoneId::of, ZoneId::getId)),
    ZONE_OFFSET(new StringExternalizer<ZoneOffset>(ZoneOffset.class, ZoneOffset::of, ZoneOffset::getId)),
    OFFSET_DATE_TIME(new BinaryExternalizer<OffsetDateTime, LocalDateTime, ZoneOffset>(OffsetDateTime.class, LOCAL_DATE_TIME.cast(LocalDateTime.class), ZONE_OFFSET.cast(ZoneOffset.class), OffsetDateTime::toLocalDateTime, OffsetDateTime::getOffset, OffsetDateTime::of)),
    OFFSET_TIME(new BinaryExternalizer<OffsetTime, LocalTime, ZoneOffset>(OffsetTime.class, LOCAL_TIME.cast(LocalTime.class), ZONE_OFFSET.cast(ZoneOffset.class), OffsetTime::toLocalTime, OffsetTime::getOffset, OffsetTime::of)),
    ZONED_DATE_TIME(new BinaryExternalizer<ZonedDateTime, LocalDateTime, ZoneId>(ZonedDateTime.class, LOCAL_DATE_TIME.cast(LocalDateTime.class), ZONE_ID.cast(ZoneId.class), ZonedDateTime::toLocalDateTime, ZonedDateTime::getZone, ZonedDateTime::of));

    private final Externalizer<?> externalizer;

    private TimeExternalizerProvider(Externalizer<?> externalizer) {
        this.externalizer = externalizer;
    }

    @Override
    public Externalizer<?> getExternalizer() {
        return this.externalizer;
    }
}

