/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Stringify;

public class Message {
    private final I18N.Key template;
    private final List<Object> values;

    public Message(I18N.Key template, Object ... values) {
        this.template = template;
        this.values = Arrays.asList(values);
    }

    public List<Object> rawValues() {
        return Collections.unmodifiableList(this.values);
    }

    public List<String> stringValues() {
        return this.values.stream().map(Stringify::asString).collect(Collectors.toList());
    }

    public I18N.Key template() {
        return this.template;
    }

    public String toString() {
        return I18N.format(this.template, this.stringValues().toArray());
    }
}

