/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.statetransfer.StateTransferGetListenersCommand;
import org.infinispan.commands.statetransfer.StateTransferGetTransactionsCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.PassthroughSingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.statetransfer.InboundTransferTask;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.FakeJTATransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class StateConsumerImpl
implements StateConsumer {
    private static final Log log = LogFactory.getLog(StateConsumerImpl.class);
    protected static final int NO_STATE_TRANSFER_IN_PROGRESS = -1;
    protected static final long STATE_TRANSFER_FLAGS = EnumUtil.bitSetOf((Enum)Flag.PUT_FOR_STATE_TRANSFER, (Enum)Flag.CACHE_MODE_LOCAL, (Enum[])new Enum[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_SHARED_CACHE_STORE, Flag.SKIP_OWNERSHIP_CHECK, Flag.SKIP_XSITE_BACKUP, Flag.SKIP_LOCKING, Flag.IRAC_STATE});
    protected static final long INVALIDATE_FLAGS = STATE_TRANSFER_FLAGS & (FlagBitSets.PUT_FOR_STATE_TRANSFER ^ 0xFFFFFFFFFFFFFFFFL);
    public static final String NO_KEY = "N/A";
    @Inject
    protected ComponentRef<Cache<Object, Object>> cache;
    @Inject
    protected LocalTopologyManager localTopologyManager;
    @Inject
    protected Configuration configuration;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected TransactionManager transactionManager;
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    protected TransactionTable transactionTable;
    @Inject
    protected InternalDataContainer<Object, Object> dataContainer;
    @Inject
    protected PersistenceManager persistenceManager;
    @Inject
    protected AsyncInterceptorChain interceptorChain;
    @Inject
    protected InvocationContextFactory icf;
    @Inject
    protected StateTransferLock stateTransferLock;
    @Inject
    protected CacheNotifier<?, ?> cacheNotifier;
    @Inject
    protected CommitManager commitManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    protected Executor nonBlockingExecutor;
    @Inject
    protected CommandAckCollector commandAckCollector;
    @Inject
    protected TriangleOrderManager triangleOrderManager;
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected InternalConflictManager<?, ?> conflictManager;
    @Inject
    protected LocalPublisherManager<Object, Object> localPublisherManager;
    @Inject
    PerCacheInboundInvocationHandler inboundInvocationHandler;
    @Inject
    XSiteStateTransferManager xSiteStateTransferManager;
    protected String cacheName;
    protected long timeout;
    protected volatile boolean isFetchEnabled;
    protected boolean isTransactional;
    protected boolean isInvalidationMode;
    protected volatile KeyInvalidationListener keyInvalidationListener;
    protected volatile CacheTopology cacheTopology;
    private final int firstTopologyAsMember = Integer.MAX_VALUE;
    protected final AtomicInteger stateTransferTopologyId = new AtomicInteger(-1);
    protected final AtomicBoolean waitingForState = new AtomicBoolean(false);
    protected CompletableFuture<Void> stateTransferFuture = CompletableFutures.completedNull();
    protected final Object transferMapsLock = new Object();
    @GuardedBy(value="transferMapsLock")
    private final Map<Address, List<InboundTransferTask>> transfersBySource = new HashMap<Address, List<InboundTransferTask>>();
    @GuardedBy(value="transferMapsLock")
    protected final Map<Integer, List<InboundTransferTask>> transfersBySegment = new HashMap<Integer, List<InboundTransferTask>>();
    protected LimitedExecutor stateRequestExecutor;
    private volatile boolean ownsData = false;
    protected RpcOptions rpcOptions;
    private volatile boolean running;
    private int numSegments;
    private final PersistenceManager.StoreChangeListener storeChangeListener = pm -> {
        this.isFetchEnabled = this.isFetchEnabled(pm.fetchPersistentState());
    };

    @Override
    public void stopApplyingState(int topologyId) {
        if (log.isTraceEnabled()) {
            log.tracef("Stop keeping track of changed keys for state transfer in topology %d", topologyId);
        }
        this.commitManager.stopTrack(Flag.PUT_FOR_STATE_TRANSFER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveTransfers() {
        Object object = this.transferMapsLock;
        synchronized (object) {
            return !this.transfersBySource.isEmpty();
        }
    }

    @Override
    public boolean isStateTransferInProgress() {
        return this.stateTransferTopologyId.get() != -1;
    }

    @Override
    public boolean isStateTransferInProgressForKey(Object key) {
        if (this.isInvalidationMode) {
            return false;
        }
        DistributionInfo distributionInfo = this.distributionManager.getCacheTopology().getDistribution(key);
        return distributionInfo.isWriteOwner() && !distributionInfo.isReadOwner();
    }

    @Override
    public boolean ownsData() {
        return this.ownsData;
    }

    @Override
    public CompletionStage<CompletionStage<Void>> onTopologyUpdate(CacheTopology cacheTopology, boolean isRebalance) {
        boolean startStateTransfer;
        boolean wasMember;
        ConsistentHash newWriteCh = cacheTopology.getWriteConsistentHash();
        CacheTopology previousCacheTopology = this.cacheTopology;
        ConsistentHash previousWriteCh = previousCacheTopology != null ? previousCacheTopology.getWriteConsistentHash() : null;
        IntSet newWriteSegments = this.getOwnedSegments(newWriteCh);
        Address address = this.rpcManager.getAddress();
        boolean isMember = cacheTopology.getMembers().contains(address);
        boolean bl = wasMember = previousWriteCh != null && previousWriteCh.getMembers().contains(address);
        if (log.isTraceEnabled()) {
            log.tracef("Received new topology for cache %s, isRebalance = %b, isMember = %b, topology = %s", new Object[]{this.cacheName, isRebalance, isMember, cacheTopology});
        }
        if (!this.ownsData && isMember) {
            this.ownsData = true;
        } else if (this.ownsData && !isMember) {
            this.ownsData = false;
        }
        boolean addedPendingCH = cacheTopology.getPendingCH() != null && wasMember && previousCacheTopology.getPendingCH() == null;
        boolean startConflictResolution = !isRebalance && cacheTopology.getPhase() == CacheTopology.Phase.CONFLICT_RESOLUTION;
        boolean bl2 = startStateTransfer = isRebalance || addedPendingCH && !startConflictResolution;
        if (startStateTransfer && !isRebalance && log.isTraceEnabled()) {
            log.tracef("Forcing startRebalance = true", new Object[0]);
        }
        CompletionStage<Void> stage = CompletableFutures.completedNull();
        if (startStateTransfer) {
            this.stateTransferTopologyId.compareAndSet(-1, cacheTopology.getTopologyId());
            this.conflictManager.cancelVersionRequests();
            if (this.cacheNotifier.hasListener(DataRehashed.class)) {
                stage = this.cacheNotifier.notifyDataRehashed(cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), cacheTopology.getUnionCH(), cacheTopology.getTopologyId(), true);
            }
        }
        stage = stage.thenCompose(ignored -> {
            if (startConflictResolution) {
                this.stateTransferTopologyId.set(-1);
            }
            this.waitingForState.set(false);
            this.stateTransferFuture = new CompletableFuture();
            this.beforeTopologyInstalled(cacheTopology.getTopologyId(), previousWriteCh, newWriteCh);
            if (!this.configuration.clustering().cacheMode().isInvalidation()) {
                this.dataContainer.addSegments(newWriteSegments);
                return CompletionStages.ignoreValue(this.persistenceManager.addSegments(newWriteSegments));
            }
            return CompletableFutures.completedNull();
        });
        stage = stage.thenCompose(ignored -> {
            if (startStateTransfer || startConflictResolution) {
                if (this.commitManager.isTracking(Flag.PUT_FOR_STATE_TRANSFER)) {
                    log.debug("Starting state transfer but key tracking is already enabled");
                } else {
                    if (log.isTraceEnabled()) {
                        log.tracef("Start keeping track of keys for state transfer", new Object[0]);
                    }
                    this.commitManager.startTrack(Flag.PUT_FOR_STATE_TRANSFER);
                }
            }
            this.stateTransferLock.acquireExclusiveTopologyLock();
            try {
                this.cacheTopology = cacheTopology;
                this.distributionManager.setCacheTopology(cacheTopology);
            }
            finally {
                this.stateTransferLock.releaseExclusiveTopologyLock();
            }
            this.stateTransferLock.notifyTopologyInstalled(cacheTopology.getTopologyId());
            this.inboundInvocationHandler.checkForReadyTasks();
            this.xSiteStateTransferManager.onTopologyUpdated(cacheTopology, this.isStateTransferInProgress());
            if (!wasMember && isMember) {
                return this.fetchClusterListeners(cacheTopology);
            }
            return CompletableFutures.completedNull();
        });
        stage = stage.thenCompose(ignored -> {
            IntSet addedSegments;
            IntSet removedSegments;
            if (startConflictResolution || !this.isTransactional && !this.isFetchEnabled) {
                return CompletableFutures.completedNull();
            }
            if (previousWriteCh == null) {
                removedSegments = IntSets.immutableEmptySet();
                addedSegments = IntSets.immutableEmptySet();
                if (log.isTraceEnabled()) {
                    log.tracef("On cache %s we have: added segments: %s", this.cacheName, addedSegments);
                }
            } else {
                IntSet previousSegments = this.getOwnedSegments(previousWriteCh);
                if (newWriteSegments.size() == this.numSegments) {
                    removedSegments = IntSets.immutableEmptySet();
                } else {
                    removedSegments = IntSets.mutableCopyFrom((Set)previousSegments);
                    removedSegments.removeAll(newWriteSegments);
                }
                addedSegments = IntSets.mutableCopyFrom((Set)newWriteSegments);
                addedSegments.removeAll(previousSegments);
                if (log.isTraceEnabled()) {
                    log.tracef("On cache %s we have: new segments: %s; old segments: %s", this.cacheName, newWriteSegments, previousSegments);
                    log.tracef("On cache %s we have: added segments: %s; removed segments: %s", this.cacheName, addedSegments, removedSegments);
                }
                this.cancelTransfers(removedSegments);
                if (!(startStateTransfer || addedSegments.isEmpty() || this.configuration.clustering().cacheMode().isScattered())) {
                    log.debugf("Not requesting segments %s because the last owner left the cluster", addedSegments);
                    addedSegments.clear();
                }
                this.restartBrokenTransfers(cacheTopology, addedSegments);
            }
            IntSet transactionOnlySegments = this.computeTransactionOnlySegments(cacheTopology, address);
            return this.handleSegments(startStateTransfer, addedSegments, removedSegments, transactionOnlySegments);
        });
        stage = stage.thenCompose(ignored -> {
            boolean changed;
            int stateTransferTopologyId = this.stateTransferTopologyId.get();
            if (log.isTraceEnabled()) {
                log.tracef("Topology update processed, stateTransferTopologyId = %d, startRebalance = %s, pending CH = %s", stateTransferTopologyId, startStateTransfer, cacheTopology.getPendingCH());
            }
            if (stateTransferTopologyId != -1 && !startStateTransfer && !cacheTopology.getPhase().isRebalance() && (changed = this.stateTransferTopologyId.compareAndSet(stateTransferTopologyId, -1))) {
                this.stopApplyingState(stateTransferTopologyId);
                if (this.cacheNotifier.hasListener(DataRehashed.class)) {
                    return this.cacheNotifier.notifyDataRehashed(previousCacheTopology.getCurrentCH(), previousCacheTopology.getPendingCH(), previousCacheTopology.getUnionCH(), cacheTopology.getTopologyId(), false);
                }
            }
            return CompletableFutures.completedNull();
        });
        return CompletionStages.handleAndCompose(stage, (ignored, throwable) -> {
            if (log.isTraceEnabled()) {
                log.tracef("Unlock State Transfer in Progress for topology ID %s", cacheTopology.getTopologyId());
            }
            this.stateTransferLock.notifyTransactionDataReceived(cacheTopology.getTopologyId());
            this.inboundInvocationHandler.checkForReadyTasks();
            if (this.stateTransferTopologyId.get() != -1 && isMember) {
                this.waitingForState.set(true);
            }
            this.notifyEndOfStateTransferIfNeeded();
            try {
                if (this.transactionTable != null) {
                    this.transactionTable.cleanupLeaverTransactions(this.rpcManager.getTransport().getMembers());
                }
            }
            catch (Exception e) {
                log.transactionCleanupError(e);
            }
            this.commandAckCollector.onMembersChange(newWriteCh.getMembers());
            switch (cacheTopology.getPhase()) {
                case READ_ALL_WRITE_ALL: 
                case READ_NEW_WRITE_ALL: {
                    this.stateTransferFuture.complete(null);
                }
            }
            if ((isMember || wasMember) && cacheTopology.getPhase() == CacheTopology.Phase.NO_REBALANCE) {
                int numSegments = newWriteCh.getNumSegments();
                IntSet removedSegments = IntSets.mutableEmptySet((int)numSegments);
                IntSet newSegments = this.getOwnedSegments(newWriteCh);
                for (int i = 0; i < numSegments; ++i) {
                    if (newSegments.contains(i)) continue;
                    removedSegments.add(i);
                }
                return this.removeStaleData(removedSegments).thenApply(ignored1 -> {
                    this.conflictManager.restartVersionRequests();
                    CompletableFutures.rethrowExceptionIfPresent(throwable);
                    return this.stateTransferFuture;
                });
            }
            CompletableFutures.rethrowExceptionIfPresent(throwable);
            return CompletableFuture.completedFuture(this.stateTransferFuture);
        });
    }

    private IntSet computeTransactionOnlySegments(CacheTopology cacheTopology, Address address) {
        if (this.configuration.transaction().transactionMode() != TransactionMode.TRANSACTIONAL || this.configuration.transaction().lockingMode() != LockingMode.PESSIMISTIC || cacheTopology.getPhase() != CacheTopology.Phase.READ_OLD_WRITE_ALL || !cacheTopology.getCurrentCH().getMembers().contains(address)) {
            return IntSets.immutableEmptySet();
        }
        IntSet transactionOnlySegments = IntSets.mutableEmptySet((int)this.numSegments);
        Set<Integer> pendingPrimarySegments = cacheTopology.getPendingCH().getPrimarySegmentsForOwner(address);
        for (Integer segment : pendingPrimarySegments) {
            List<Address> currentOwners = cacheTopology.getCurrentCH().locateOwnersForSegment(segment);
            if (currentOwners.get(0).equals(address) || !currentOwners.contains(address)) continue;
            transactionOnlySegments.add((Object)segment);
        }
        return transactionOnlySegments;
    }

    private CompletionStage<Void> fetchClusterListeners(CacheTopology cacheTopology) {
        if (!this.configuration.clustering().cacheMode().isDistributed() && !this.configuration.clustering().cacheMode().isScattered()) {
            return CompletableFutures.completedNull();
        }
        return this.getClusterListeners(cacheTopology.getTopologyId(), cacheTopology.getReadConsistentHash().getMembers()).thenAccept(callables -> {
            Cache<Object, Object> cache = this.cache.wired();
            for (ClusterListenerReplicateCallable callable : callables) {
                try {
                    callable.accept(cache.getCacheManager(), cache);
                }
                catch (Exception e) {
                    log.clusterListenerInstallationFailure(e);
                }
            }
        });
    }

    protected void beforeTopologyInstalled(int topologyId, ConsistentHash previousWriteCh, ConsistentHash newWriteCh) {
    }

    protected boolean notifyEndOfStateTransferIfNeeded() {
        if (this.waitingForState.get()) {
            if (this.hasActiveTransfers()) {
                if (log.isTraceEnabled()) {
                    log.tracef("No end of state transfer notification, active transfers still exist", new Object[0]);
                }
                return false;
            }
            if (this.waitingForState.compareAndSet(true, false)) {
                int topologyId = this.stateTransferTopologyId.get();
                log.debugf("Finished receiving of segments for cache %s for topology %d.", this.cacheName, topologyId);
                this.stopApplyingState(topologyId);
                this.stateTransferFuture.complete(null);
            }
            if (log.isTraceEnabled()) {
                log.tracef("No end of state transfer notification, waitingForState already set to false by another thread", new Object[0]);
            }
            return false;
        }
        if (log.isTraceEnabled()) {
            log.tracef("No end of state transfer notification, waitingForState already set to false by another thread", new Object[0]);
        }
        return true;
    }

    protected IntSet getOwnedSegments(ConsistentHash consistentHash) {
        Address address = this.rpcManager.getAddress();
        return IntSets.from(consistentHash.getSegmentsForOwner(address));
    }

    @Override
    public CompletionStage<?> applyState(Address sender, int topologyId, boolean pushTransfer, Collection<StateChunk> stateChunks) {
        ConsistentHash wCh = this.cacheTopology.getWriteConsistentHash();
        if (!wCh.getMembers().contains(this.rpcManager.getAddress())) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignoring received state because we are no longer a member of cache %s", this.cacheName);
            }
            return CompletableFutures.completedNull();
        }
        int rebalanceTopologyId = this.stateTransferTopologyId.get();
        if (rebalanceTopologyId == -1 && !pushTransfer) {
            log.debugf("Discarding state response with topology id %d for cache %s, we don't have a state transfer in progress", topologyId, this.cacheName);
            return CompletableFutures.completedNull();
        }
        if (topologyId < rebalanceTopologyId) {
            log.debugf("Discarding state response with old topology id %d for cache %s, state transfer request topology was %b", topologyId, this.cacheName, this.waitingForState);
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Before applying the received state the data container of cache %s has %d keys", this.cacheName, this.dataContainer.sizeIncludingExpired());
        }
        IntSet mySegments = IntSets.from(wCh.getSegmentsForOwner(this.rpcManager.getAddress()));
        Iterator<StateChunk> iterator = stateChunks.iterator();
        return this.applyStateIteration(sender, pushTransfer, mySegments, iterator).whenComplete((v, t) -> {
            if (log.isTraceEnabled()) {
                log.tracef("After applying the received state the data container of cache %s has %d keys", this.cacheName, this.dataContainer.sizeIncludingExpired());
                Object object = this.transferMapsLock;
                synchronized (object) {
                    log.tracef("Segments not received yet for cache %s: %s", this.cacheName, this.transfersBySource);
                }
            }
        });
    }

    private CompletionStage<?> applyStateIteration(Address sender, boolean pushTransfer, IntSet mySegments, Iterator<StateChunk> iterator) {
        CompletionStage<Object> chunkStage = CompletableFutures.completedNull();
        while (iterator.hasNext() && CompletionStages.isCompletedSuccessfully(chunkStage)) {
            StateChunk stateChunk = iterator.next();
            if (pushTransfer) {
                chunkStage = this.doApplyState(sender, stateChunk.getSegmentId(), stateChunk.getCacheEntries());
                continue;
            }
            chunkStage = this.applyChunk(sender, mySegments, stateChunk);
        }
        if (!iterator.hasNext()) {
            return chunkStage;
        }
        return chunkStage.thenCompose(v -> this.applyStateIteration(sender, pushTransfer, mySegments, iterator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> applyChunk(Address sender, IntSet mySegments, StateChunk stateChunk) {
        InboundTransferTask inboundTransfer;
        if (!mySegments.contains(stateChunk.getSegmentId())) {
            log.debugf("Discarding received cache entries for segment %d of cache %s because they do not belong to this node.", stateChunk.getSegmentId(), this.cacheName);
            return CompletableFutures.completedNull();
        }
        Object object = this.transferMapsLock;
        synchronized (object) {
            List<InboundTransferTask> inboundTransfers = this.transfersBySegment.get(stateChunk.getSegmentId());
            inboundTransfer = inboundTransfers != null ? (InboundTransferTask)inboundTransfers.stream().filter(task -> task.getSource().equals(sender)).findFirst().orElse(null) : null;
        }
        if (inboundTransfer != null) {
            return this.doApplyState(sender, stateChunk.getSegmentId(), stateChunk.getCacheEntries()).thenAccept(v -> inboundTransfer.onStateReceived(stateChunk.getSegmentId(), stateChunk.isLastChunk()));
        }
        if (this.cache.wired().getStatus().allowInvocations()) {
            log.ignoringUnsolicitedState(sender, stateChunk.getSegmentId(), this.cacheName);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<?> doApplyState(Address sender, int segmentId, Collection<InternalCacheEntry<?, ?>> cacheEntries) {
        boolean transactional;
        if (cacheEntries == null || cacheEntries.isEmpty()) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Applying new state chunk for segment %d of cache %s from node %s: received %d cache entries", new Object[]{segmentId, this.cacheName, sender, cacheEntries.size()});
        }
        boolean bl = transactional = this.transactionManager != null;
        if (transactional) {
            String key = NO_KEY;
            FakeJTATransaction transaction = new FakeJTATransaction();
            InvocationContext ctx = this.icf.createInvocationContext((Transaction)transaction, false);
            LocalTransaction localTransaction = (LocalTransaction)((LocalTxInvocationContext)ctx).getCacheTransaction();
            try {
                localTransaction.setStateTransferFlag(Flag.PUT_FOR_STATE_TRANSFER);
                for (InternalCacheEntry<?, ?> e : cacheEntries) {
                    key = e.getKey();
                    CompletableFuture<?> future = this.invokePut(segmentId, ctx, e);
                    if (future.isDone()) continue;
                    throw new IllegalStateException("State transfer in-tx put should always be synchronous");
                }
            }
            catch (Throwable t2) {
                this.logApplyException(t2, key);
                return this.invokeRollback(localTransaction).handle((rv, t1) -> {
                    this.transactionTable.removeLocalTransaction(localTransaction);
                    if (t1 != null) {
                        t2.addSuppressed((Throwable)t1);
                    }
                    return null;
                });
            }
            return this.invoke1PCPrepare(localTransaction).whenComplete((rv, t) -> {
                this.transactionTable.removeLocalTransaction(localTransaction);
                if (t != null) {
                    this.logApplyException((Throwable)t, NO_KEY);
                }
            });
        }
        AggregateCompletionStage<Void> aggregateStage = CompletionStages.aggregateCompletionStage();
        for (InternalCacheEntry<?, ?> e : cacheEntries) {
            InvocationContext ctx = this.icf.createSingleKeyNonTxInvocationContext();
            CompletableFuture<?> putStage = this.invokePut(segmentId, ctx, e);
            aggregateStage.dependsOn(putStage.exceptionally(t -> {
                this.logApplyException((Throwable)t, e.getKey());
                return null;
            }));
        }
        return aggregateStage.freeze();
    }

    private CompletionStage<?> invoke1PCPrepare(LocalTransaction localTransaction) {
        PrepareCommand prepareCommand = Configurations.isTxVersioned(this.configuration) ? this.commandsFactory.buildVersionedPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true) : this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true);
        LocalTxInvocationContext ctx = this.icf.createTxInvocationContext(localTransaction);
        return this.interceptorChain.invokeAsync(ctx, prepareCommand);
    }

    private CompletionStage<?> invokeRollback(LocalTransaction localTransaction) {
        RollbackCommand prepareCommand = this.commandsFactory.buildRollbackCommand(localTransaction.getGlobalTransaction());
        LocalTxInvocationContext ctx = this.icf.createTxInvocationContext(localTransaction);
        return this.interceptorChain.invokeAsync(ctx, prepareCommand);
    }

    private CompletableFuture<?> invokePut(int segmentId, InvocationContext ctx, InternalCacheEntry<?, ?> e) {
        InternalMetadataImpl metadata = new InternalMetadataImpl(e);
        PutKeyValueCommand put = this.commandsFactory.buildPutKeyValueCommand(e.getKey(), e.getValue(), segmentId, metadata, STATE_TRANSFER_FLAGS);
        put.setInternalMetadata(e.getInternalMetadata());
        ctx.setLockOwner(put.getKeyLockOwner());
        return this.interceptorChain.invokeAsync(ctx, put);
    }

    private void logApplyException(Throwable t, Object key) {
        if (!this.cache.wired().getStatus().allowInvocations()) {
            log.tracef("Cache %s is shutting down, stopping state transfer", this.cacheName);
        } else {
            log.problemApplyingStateForKey(key, t);
        }
    }

    private void applyTransactions(Address sender, Collection<TransactionInfo> transactions, int topologyId) {
        log.debugf("Applying %d transactions for cache %s transferred from node %s", transactions.size(), this.cacheName, sender);
        if (this.isTransactional) {
            for (TransactionInfo transactionInfo : transactions) {
                AbstractCacheTransaction tx;
                block5: {
                    GlobalTransaction gtx = transactionInfo.getGlobalTransaction();
                    if (this.rpcManager.getAddress().equals(gtx.getAddress())) continue;
                    gtx.setRemote(true);
                    tx = this.transactionTable.getLocalTransaction(gtx);
                    if (tx == null && (tx = this.transactionTable.getRemoteTransaction(gtx)) == null) {
                        try {
                            tx = this.transactionTable.getOrCreateRemoteTransaction(gtx, transactionInfo.getModifications(), topologyId - 1);
                            ((RemoteTransaction)tx).setLookedUpEntriesTopology(topologyId - 1);
                        }
                        catch (Throwable t) {
                            if (!log.isTraceEnabled()) break block5;
                            log.tracef(t, "Failed to create remote transaction %s", gtx);
                        }
                    }
                }
                if (tx == null) continue;
                transactionInfo.getLockedKeys().forEach(tx::addBackupLockForKey);
            }
        }
    }

    @Start(priority=20)
    public void start() {
        this.cacheName = this.cache.wired().getName();
        this.isInvalidationMode = this.configuration.clustering().cacheMode().isInvalidation();
        this.isTransactional = this.configuration.transaction().transactionMode().isTransactional();
        this.timeout = this.configuration.clustering().stateTransfer().timeout();
        this.numSegments = this.configuration.clustering().hash().numSegments();
        this.isFetchEnabled = this.isFetchEnabled(this.configuration.persistence().fetchPersistentState());
        this.rpcOptions = new RpcOptions(DeliverOrder.NONE, this.timeout, TimeUnit.MILLISECONDS);
        this.stateRequestExecutor = new LimitedExecutor("StateRequest-" + this.cacheName, this.nonBlockingExecutor, 1);
        this.persistenceManager.addStoreListener(this.storeChangeListener);
        this.running = true;
    }

    private boolean isFetchEnabled(boolean fetchPersistenceState) {
        return this.configuration.clustering().cacheMode().needsStateTransfer() && (this.configuration.clustering().stateTransfer().fetchInMemoryState() || fetchPersistenceState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop(priority=0)
    public void stop() {
        if (log.isTraceEnabled()) {
            log.tracef("Shutting down StateConsumer of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.running = false;
        try {
            Object object = this.transferMapsLock;
            synchronized (object) {
                ArrayList<List<InboundTransferTask>> transfers = new ArrayList<List<InboundTransferTask>>(this.transfersBySource.values());
                this.transfersBySource.clear();
                this.transfersBySegment.clear();
                for (List list : transfers) {
                    list.forEach(InboundTransferTask::cancel);
                }
            }
            this.stateRequestExecutor.shutdownNow();
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to stop StateConsumer of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.persistenceManager.removeStoreListener(this.storeChangeListener);
    }

    public void setKeyInvalidationListener(KeyInvalidationListener keyInvalidationListener) {
        this.keyInvalidationListener = keyInvalidationListener;
    }

    protected CompletionStage<Void> handleSegments(boolean startRebalance, IntSet addedSegments, IntSet removedSegments, IntSet transactionOnlySegments) {
        if (addedSegments.isEmpty() && transactionOnlySegments.isEmpty()) {
            return CompletableFutures.completedNull();
        }
        log.debugf("Adding inbound state transfer for segments %s", addedSegments);
        HashSet<Address> excludedSources = new HashSet<Address>();
        HashMap<Address, IntSet> sources = new HashMap<Address, IntSet>();
        CompletionStage<Void> stage = CompletableFutures.completedNull();
        if (this.isTransactional) {
            stage = this.requestTransactions(addedSegments, transactionOnlySegments, sources, excludedSources);
        }
        if (this.isFetchEnabled) {
            stage = stage.thenRun(() -> this.requestSegments(addedSegments, sources, excludedSources));
        }
        return stage;
    }

    private void findSources(IntSet segments, Map<Address, IntSet> sources, Set<Address> excludedSources, boolean ignoreOwnedSegments) {
        if (this.cache.wired().getStatus().isTerminated()) {
            return;
        }
        IntSet segmentsWithoutSource = IntSets.mutableEmptySet((int)this.numSegments);
        PrimitiveIterator.OfInt iter = segments.iterator();
        while (iter.hasNext()) {
            int segmentId = iter.nextInt();
            Address source = this.findSource(segmentId, excludedSources, ignoreOwnedSegments);
            if (source != null) {
                IntSet segmentsFromSource = sources.computeIfAbsent(source, k -> IntSets.mutableEmptySet((int)this.numSegments));
                segmentsFromSource.set(segmentId);
                continue;
            }
            segmentsWithoutSource.set(segmentId);
        }
        if (!segmentsWithoutSource.isEmpty()) {
            log.noLiveOwnersFoundForSegments((Collection<Integer>)segmentsWithoutSource, this.cacheName, excludedSources);
        }
    }

    private Address findSource(int segmentId, Set<Address> excludedSources, boolean ignoreOwnedSegment) {
        List<Address> owners = this.cacheTopology.getReadConsistentHash().locateOwnersForSegment(segmentId);
        if (!ignoreOwnedSegment || !owners.contains(this.rpcManager.getAddress())) {
            for (Address o : owners) {
                if (o.equals(this.rpcManager.getAddress()) || excludedSources.contains(o)) continue;
                return o;
            }
        }
        return null;
    }

    private CompletionStage<Void> requestTransactions(IntSet dataSegments, IntSet transactionOnlySegments, Map<Address, IntSet> sources, Set<Address> excludedSources) {
        this.findSources(dataSegments, sources, excludedSources, true);
        AggregateCompletionStage<Void> aggregateStage = CompletionStages.aggregateCompletionStage();
        IntSet failedSegments = IntSets.concurrentSet((int)this.numSegments);
        ConcurrentHashMap.KeySetView sourcesToExclude = ConcurrentHashMap.newKeySet();
        int topologyId = this.cacheTopology.getTopologyId();
        sources.forEach((source, segmentsFromSource) -> {
            CompletionStage<Response> sourceStage = this.requestAndApplyTransactions(failedSegments, sourcesToExclude, topologyId, (Address)source, (IntSet)segmentsFromSource);
            aggregateStage.dependsOn(sourceStage);
        });
        HashMap<Address, IntSet> transactionOnlySources = new HashMap<Address, IntSet>();
        this.findSources(transactionOnlySegments, transactionOnlySources, excludedSources, false);
        transactionOnlySources.forEach((source, segmentsFromSource) -> {
            CompletionStage<Response> sourceStage = this.requestAndApplyTransactions(failedSegments, sourcesToExclude, topologyId, (Address)source, (IntSet)segmentsFromSource);
            aggregateStage.dependsOn(sourceStage);
        });
        return aggregateStage.freeze().thenCompose(ignored -> {
            if (failedSegments.isEmpty()) {
                return CompletableFutures.completedNull();
            }
            excludedSources.addAll(sourcesToExclude);
            sources.clear();
            return this.requestTransactions(dataSegments, transactionOnlySegments, sources, excludedSources);
        });
    }

    private CompletionStage<Response> requestAndApplyTransactions(IntSet failedSegments, Set<Address> sourcesToExclude, int topologyId, Address source, IntSet segmentsFromSource) {
        return this.getTransactions(source, segmentsFromSource, topologyId).whenComplete((response, throwable) -> this.processTransactionsResponse(failedSegments, sourcesToExclude, topologyId, source, segmentsFromSource, (Response)response, (Throwable)throwable));
    }

    private void processTransactionsResponse(IntSet failedSegments, Set<Address> sourcesToExclude, int topologyId, Address source, IntSet segmentsFromSource, Response response, Throwable throwable) {
        boolean failed = false;
        boolean exclude = false;
        if (throwable != null) {
            if (this.cache.wired().getStatus().isTerminated()) {
                log.debugf("Cache %s has stopped while requesting transactions", this.cacheName);
                return;
            }
            log.failedToRetrieveTransactionsForSegments(this.cacheName, source, (Collection<Integer>)segmentsFromSource, throwable);
            failed = true;
        }
        if (response instanceof SuccessfulResponse) {
            List transactions = (List)((SuccessfulResponse)response).getResponseValue();
            this.applyTransactions(source, transactions, topologyId);
        } else if (response instanceof CacheNotFoundResponse) {
            log.debugf("Cache %s was stopped on node %s before sending transaction information", this.cacheName, source);
            failed = true;
            exclude = true;
        } else {
            log.unsuccessfulResponseRetrievingTransactionsForSegments(source, response);
            failed = true;
        }
        if (failed) {
            failedSegments.addAll(segmentsFromSource);
        }
        if (exclude) {
            sourcesToExclude.add(source);
        }
    }

    private CompletionStage<Collection<ClusterListenerReplicateCallable<Object, Object>>> getClusterListeners(int topologyId, List<Address> sources) {
        if (sources.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Unable to acquire cluster listeners from other members, assuming none are present");
            }
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        Address source = sources.get(0);
        if (sources.get(0).equals(this.rpcManager.getAddress())) {
            return this.getClusterListeners(topologyId, sources.subList(1, sources.size()));
        }
        if (log.isTraceEnabled()) {
            log.tracef("Requesting cluster listeners of cache %s from node %s", this.cacheName, sources);
        }
        StateTransferGetListenersCommand cmd = this.commandsFactory.buildStateTransferGetListenersCommand(topologyId);
        CompletionStage<ValidResponse> remoteStage = this.rpcManager.invokeCommand(source, (ReplicableCommand)cmd, SingleResponseCollector.validOnly(), this.rpcOptions);
        return CompletionStages.handleAndCompose(remoteStage, (response, throwable) -> {
            if (throwable != null) {
                log.exceptionDuringClusterListenerRetrieval(source, (Throwable)throwable);
            }
            if (response instanceof SuccessfulResponse) {
                return CompletableFuture.completedFuture((Collection)response.getResponseValue());
            }
            log.unsuccessfulResponseForClusterListeners(source, (Response)response);
            return this.getClusterListeners(topologyId, sources.subList(1, sources.size()));
        });
    }

    private CompletionStage<Response> getTransactions(Address source, IntSet segments, int topologyId) {
        if (log.isTraceEnabled()) {
            log.tracef("Requesting transactions from node %s for segments %s", source, segments);
        }
        StateTransferGetTransactionsCommand cmd = this.commandsFactory.buildStateTransferGetTransactionsCommand(topologyId, segments);
        return this.rpcManager.invokeCommand(source, (ReplicableCommand)cmd, PassthroughSingleResponseCollector.INSTANCE, this.rpcOptions);
    }

    private void requestSegments(IntSet segments, Map<Address, IntSet> sources, Set<Address> excludedSources) {
        if (sources.isEmpty()) {
            this.findSources(segments, sources, excludedSources, true);
        }
        for (Map.Entry<Address, IntSet> e : sources.entrySet()) {
            this.addTransfer(e.getKey(), e.getValue());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Finished adding inbound state transfer for segments %s", segments, this.cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTransfers(IntSet removedSegments) {
        Object object = this.transferMapsLock;
        synchronized (object) {
            ArrayList segmentsToCancel = new ArrayList(removedSegments);
            while (!segmentsToCancel.isEmpty()) {
                int segmentId = (Integer)segmentsToCancel.remove(0);
                List<InboundTransferTask> inboundTransfers = this.transfersBySegment.get(segmentId);
                if (inboundTransfers == null) continue;
                for (InboundTransferTask inboundTransfer : inboundTransfers) {
                    IntSet cancelledSegments = IntSets.mutableCopyFrom((Set)removedSegments);
                    cancelledSegments.retainAll(inboundTransfer.getSegments());
                    segmentsToCancel.removeAll((Collection<?>)cancelledSegments);
                    this.transfersBySegment.keySet().removeAll((Collection<?>)cancelledSegments);
                    inboundTransfer.cancelSegments(cancelledSegments);
                    if (!inboundTransfer.isCancelled()) continue;
                    this.removeTransfer(inboundTransfer);
                }
            }
        }
    }

    protected CompletionStage<Void> removeStaleData(IntSet removedSegments) {
        if (this.configuration.clustering().cacheMode().isInvalidation()) {
            return CompletableFutures.completedNull();
        }
        log.debugf("Removing no longer owned entries for cache %s", this.cacheName);
        if (this.keyInvalidationListener != null) {
            this.keyInvalidationListener.beforeInvalidation(removedSegments, IntSets.immutableEmptySet());
        }
        this.localPublisherManager.segmentsLost(removedSegments);
        this.dataContainer.removeSegments(removedSegments);
        if (removedSegments.isEmpty()) {
            return CompletableFutures.completedNull();
        }
        return this.persistenceManager.removeSegments(removedSegments).thenCompose(removed -> this.invalidateStaleEntries(removedSegments, (Boolean)removed));
    }

    private CompletionStage<Void> invalidateStaleEntries(IntSet removedSegments, Boolean removed) {
        if (removed.booleanValue()) {
            return CompletableFutures.completedNull();
        }
        AtomicLong removedEntriesCounter = new AtomicLong();
        Predicate<Object> filter = key -> removedSegments.contains(this.getSegment(key));
        Publisher<Object> publisher = this.persistenceManager.publishKeys(filter, PersistenceManager.AccessMode.PRIVATE);
        return Flowable.fromPublisher(publisher).onErrorResumeNext(throwable -> {
            Log.PERSISTENCE.failedLoadingKeysFromCacheStore((Throwable)throwable);
            return Flowable.empty();
        }).buffer(this.configuration.clustering().stateTransfer().chunkSize()).concatMapCompletable(keysToRemove -> {
            removedEntriesCounter.addAndGet(keysToRemove.size());
            return Completable.fromCompletionStage(this.invalidateBatch((Collection<Object>)keysToRemove));
        }).toCompletionStage(null).thenRun(() -> {
            if (log.isTraceEnabled()) {
                log.tracef("Removed %d keys, data container now has %d keys", removedEntriesCounter.get(), this.dataContainer.sizeIncludingExpired());
            }
        });
    }

    protected CompletionStage<Void> invalidateBatch(Collection<Object> keysToRemove) {
        InvalidateCommand invalidateCmd = this.commandsFactory.buildInvalidateCommand(INVALIDATE_FLAGS, keysToRemove.toArray());
        NonTxInvocationContext ctx = this.icf.createNonTxInvocationContext();
        ctx.setLockOwner(invalidateCmd.getKeyLockOwner());
        return this.interceptorChain.invokeAsync(ctx, invalidateCmd).handle((ignored, throwable) -> {
            if (!(throwable instanceof IllegalLifecycleStateException) && throwable != null) {
                log.failedToInvalidateKeys((Throwable)throwable);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartBrokenTransfers(CacheTopology cacheTopology, IntSet addedSegments) {
        HashSet<Address> members = new HashSet<Address>(cacheTopology.getReadConsistentHash().getMembers());
        Object object = this.transferMapsLock;
        synchronized (object) {
            Iterator<Map.Entry<Address, List<InboundTransferTask>>> it = this.transfersBySource.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Address, List<InboundTransferTask>> entry = it.next();
                Address source = entry.getKey();
                if (members.contains(source)) continue;
                if (log.isTraceEnabled()) {
                    log.tracef("Removing inbound transfers from source %s for cache %s", source, this.cacheName);
                }
                List<InboundTransferTask> inboundTransfers = entry.getValue();
                it.remove();
                for (InboundTransferTask inboundTransfer : inboundTransfers) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Removing inbound transfers from node %s for segments %s", source, inboundTransfer.getSegments());
                    }
                    IntSet unfinishedSegments = inboundTransfer.getUnfinishedSegments();
                    inboundTransfer.cancel();
                    addedSegments.addAll(unfinishedSegments);
                    this.transfersBySegment.keySet().removeAll((Collection<?>)unfinishedSegments);
                }
            }
            addedSegments.removeAll(this.transfersBySegment.keySet());
        }
    }

    private int getSegment(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InboundTransferTask addTransfer(Address source, IntSet segmentsFromSource) {
        InboundTransferTask inboundTransfer;
        Object object = this.transferMapsLock;
        synchronized (object) {
            if (log.isTraceEnabled()) {
                log.tracef("Adding transfer from %s for segments %s", source, segmentsFromSource);
            }
            segmentsFromSource.removeAll(this.transfersBySegment.keySet());
            if (segmentsFromSource.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("All segments are already in progress, skipping", new Object[0]);
                }
                return null;
            }
            inboundTransfer = new InboundTransferTask(segmentsFromSource, source, this.cacheTopology.getTopologyId(), this.rpcManager, this.commandsFactory, this.timeout, this.cacheName, true);
            this.addTransfer(inboundTransfer, segmentsFromSource);
        }
        this.stateRequestExecutor.executeAsync(() -> {
            CompletionStage<Void> transferStarted = inboundTransfer.requestSegments();
            return transferStarted.whenComplete((aVoid, throwable) -> this.onTaskCompletion(inboundTransfer));
        });
        return inboundTransfer;
    }

    @GuardedBy(value="transferMapsLock")
    protected void addTransfer(InboundTransferTask inboundTransfer, IntSet segments) {
        if (!this.running) {
            throw new IllegalLifecycleStateException("State consumer is not running for cache " + this.cacheName);
        }
        PrimitiveIterator.OfInt iter = segments.iterator();
        while (iter.hasNext()) {
            int segmentId = iter.nextInt();
            this.transfersBySegment.computeIfAbsent(segmentId, s -> new ArrayList()).add(inboundTransfer);
        }
        this.transfersBySource.computeIfAbsent(inboundTransfer.getSource(), s -> new ArrayList()).add(inboundTransfer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeTransfer(InboundTransferTask inboundTransfer) {
        boolean found = false;
        Object object = this.transferMapsLock;
        synchronized (object) {
            List<InboundTransferTask> transfers;
            if (log.isTraceEnabled()) {
                log.tracef("Removing inbound transfers from node %s for segments %s", inboundTransfer.getSegments(), inboundTransfer.getSource(), this.cacheName);
            }
            if ((transfers = this.transfersBySource.get(inboundTransfer.getSource())) != null && (found = transfers.remove(inboundTransfer)) && transfers.isEmpty()) {
                this.transfersBySource.remove(inboundTransfer.getSource());
            }
            for (Integer segment : inboundTransfer.getSegments()) {
                List<InboundTransferTask> innerTransfers = this.transfersBySegment.get(segment);
                if (innerTransfers == null || !innerTransfers.remove(inboundTransfer) || !innerTransfers.isEmpty()) continue;
                this.transfersBySegment.remove(segment);
            }
        }
        return found;
    }

    protected void onTaskCompletion(InboundTransferTask inboundTransfer) {
        if (log.isTraceEnabled()) {
            log.tracef("Inbound transfer finished: %s", inboundTransfer);
        }
        if (inboundTransfer.isCompletedSuccessfully()) {
            this.removeTransfer(inboundTransfer);
            this.notifyEndOfStateTransferIfNeeded();
        }
    }

    public static interface KeyInvalidationListener {
        public void beforeInvalidation(IntSet var1, IntSet var2);
    }
}

