/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@ConfiguredBy(value=RemoteStoreConfiguration.class)
public class RemoteStore<K, V>
implements NonBlockingStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(RemoteStore.class, Log.class);
    private RemoteStoreConfiguration configuration;
    private RemoteCacheManager remoteCacheManager;
    private InternalRemoteCache<Object, Object> remoteCache;
    private InternalEntryFactory iceFactory;
    private static final String LIFESPAN = "lifespan";
    private static final String MAXIDLE = "maxidle";
    protected InitializationContext ctx;
    private MarshallableEntryFactory<K, V> entryFactory;
    private BlockingManager blockingManager;
    private int segmentCount;
    private boolean supportsSegmentation;

    public CompletionStage<Void> start(InitializationContext ctx) {
        PersistenceMarshaller marshaller;
        this.ctx = ctx;
        this.configuration = (RemoteStoreConfiguration)ctx.getConfiguration();
        this.entryFactory = ctx.getMarshallableEntryFactory();
        this.blockingManager = ctx.getBlockingManager();
        Configuration cacheConfiguration = ctx.getCache().getCacheConfiguration();
        ClusteringConfiguration clusterConfiguration = cacheConfiguration.clustering();
        this.segmentCount = clusterConfiguration.hash().numSegments();
        if (this.configuration.marshaller() != null) {
            marshaller = (Marshaller)Util.getInstance((String)this.configuration.marshaller(), (ClassLoader)ctx.getCache().getAdvancedCache().getClassLoader());
        } else {
            Object object = marshaller = this.configuration.rawValues() ? ctx.getPersistenceMarshaller().getUserMarshaller() : ctx.getPersistenceMarshaller();
        }
        if (clusterConfiguration.cacheMode().isClustered() && !this.configuration.shared()) {
            throw log.clusteredRequiresBeingShared();
        }
        if (this.configuration.rawValues() && this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
        ConfigurationBuilder builder = this.buildRemoteConfiguration(this.configuration, (Marshaller)marshaller);
        return this.blockingManager.supplyBlocking(() -> {
            this.remoteCacheManager = new RemoteCacheManager(builder.build());
            this.remoteCache = this.configuration.remoteCacheName().isEmpty() ? (InternalRemoteCache)this.remoteCacheManager.getCache() : (InternalRemoteCache)this.remoteCacheManager.getCache(this.configuration.remoteCacheName());
            return this.remoteCache.ping();
        }, (Object)"RemoteStore-start").thenCompose(Function.identity()).thenAccept(arg_0 -> this.lambda$start$1(ctx, (Marshaller)marshaller, arg_0));
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        EnumSet<NonBlockingStore.Characteristic> characteristics = EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.SHAREABLE);
        if (this.supportsSegmentation) {
            characteristics.add(NonBlockingStore.Characteristic.SEGMENTABLE);
        }
        return characteristics;
    }

    public CompletionStage<Void> stop() {
        return this.blockingManager.runBlocking(() -> {
            if (this.remoteCacheManager != null) {
                this.remoteCacheManager.stop();
            }
        }, (Object)"RemoteStore-stop");
    }

    public CompletionStage<Boolean> isAvailable() {
        return this.remoteCache.ping().handle((v, t) -> t == null && v.isSuccess());
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        if (this.configuration.rawValues()) {
            Object unwrappedKey = RemoteStore.unwrap(key);
            return this.remoteCache.getWithMetadataAsync(unwrappedKey).thenApply(metadataValue -> {
                if (metadataValue == null) {
                    return null;
                }
                Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(metadataValue.getVersion())).lifespan((long)metadataValue.getLifespan(), TimeUnit.SECONDS).maxIdle((long)metadataValue.getMaxIdle(), TimeUnit.SECONDS).build();
                long created = metadataValue.getCreated();
                long lastUsed = metadataValue.getLastUsed();
                Object realValue = RemoteStore.wrap(metadataValue.getValue());
                return this.entryFactory.create(key, realValue, metadata, null, created, lastUsed);
            });
        }
        Object unwrappedKey = RemoteStore.unwrap(key);
        return this.remoteCache.getAsync(unwrappedKey).thenApply(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof MarshalledValue) {
                return this.entryFactory.create(key, (MarshalledValue)value);
            }
            return this.entryFactory.create(key, value);
        });
    }

    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        key = RemoteStore.unwrap(key);
        return this.remoteCache.containsKeyAsync(key);
    }

    public Flowable<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        IntSet segmentsToUse = this.configuration.segmented() ? segments : null;
        Flowable keyFlowable = Flowable.fromPublisher((Publisher)this.remoteCache.publishEntries("org.infinispan.server.hotrod.HotRodServer$ToEmptyBytesKeyValueFilterConverter", null, (Set)segmentsToUse, 512)).map(Map.Entry::getKey).map(RemoteStore::wrap);
        if (filter != null) {
            keyFlowable = keyFlowable.filter(filter::test);
        }
        return keyFlowable;
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        IntSet segmentsToUse;
        Object object = segmentsToUse = this.configuration.segmented() ? segments : null;
        if (this.configuration.rawValues()) {
            Flowable entryFlowable = Flowable.fromPublisher((Publisher)this.remoteCache.publishEntriesWithMetadata((Set)segmentsToUse, 512));
            if (filter != null) {
                entryFlowable = entryFlowable.filter(e -> filter.test((Object)RemoteStore.wrap(e.getKey())));
            }
            return entryFlowable.map(e -> {
                MetadataValue value = (MetadataValue)e.getValue();
                Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(value.getVersion())).lifespan((long)value.getLifespan(), TimeUnit.SECONDS).maxIdle((long)value.getMaxIdle(), TimeUnit.SECONDS).build();
                long created = value.getCreated();
                long lastUsed = value.getLastUsed();
                Object realValue = value.getValue();
                return this.entryFactory.create(RemoteStore.wrap(e.getKey()), RemoteStore.wrap(realValue), metadata, null, created, lastUsed);
            });
        }
        Flowable entryFlowable = Flowable.fromPublisher((Publisher)this.remoteCache.publishEntries(null, null, (Set)segmentsToUse, 512));
        if (filter != null) {
            entryFlowable = entryFlowable.filter(e -> filter.test((Object)RemoteStore.wrap(e.getKey())));
        }
        return entryFlowable.map(e -> e.getValue() == null ? null : this.entryFactory.create(RemoteStore.wrap(e.getKey()), (MarshalledValue)e.getValue()));
    }

    private static <T> T wrap(Object obj) {
        if (obj instanceof byte[]) {
            obj = new WrappedByteArray((byte[])obj);
        }
        return (T)obj;
    }

    private static <T> T unwrap(Object obj) {
        if (obj instanceof WrappedByteArray) {
            return (T)((WrappedByteArray)obj).getBytes();
        }
        return (T)obj;
    }

    public CompletionStage<Long> size(IntSet segments) {
        if (this.segmentCount == segments.size()) {
            return this.remoteCache.sizeAsync();
        }
        return this.publishKeys(segments, null).count().toCompletionStage();
    }

    public CompletionStage<Long> approximateSize(IntSet segments) {
        return this.remoteCache.serverStatisticsAsync().thenApply(stats -> this.getApproximateSizeStatistic((ServerStatistics)stats, segments.size()));
    }

    private long getApproximateSizeStatistic(ServerStatistics serverStatistics, long segments) {
        long serverSize = serverStatistics.getIntStatistic("approximateEntriesUnique").intValue();
        return serverSize * segments / (long)this.segmentCount;
    }

    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        return Flowable.empty();
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        Metadata metadata;
        if (log.isTraceEnabled()) {
            log.tracef("Adding entry: %s", entry);
        }
        long lifespan = (metadata = entry.getMetadata()) != null ? this.toSeconds(metadata.lifespan(), entry.getKey(), LIFESPAN) : -1L;
        long maxIdle = metadata != null ? this.toSeconds(metadata.maxIdle(), entry.getKey(), MAXIDLE) : -1L;
        Object key = this.getKey(entry);
        Object value = this.getValue(entry);
        return this.remoteCache.putAsync(key, value, lifespan, TimeUnit.SECONDS, maxIdle, TimeUnit.SECONDS).thenApply(CompletableFutures.toNullFunction());
    }

    private Object getKey(MarshallableEntry entry) {
        return RemoteStore.unwrap(entry.getKey());
    }

    private Object getValue(MarshallableEntry entry) {
        if (this.configuration.rawValues()) {
            return RemoteStore.unwrap(entry.getValue());
        }
        return entry.getMarshalledValue();
    }

    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        Completable removeCompletable = Flowable.fromPublisher(removePublisher).flatMap(Flowable::fromPublisher, publisherCount).map(RemoteStore::unwrap).flatMapCompletable(key -> Completable.fromCompletionStage((CompletionStage)this.remoteCache.removeAsync(key)), false, 10);
        Completable putCompletable = Flowable.fromPublisher(writePublisher).flatMap(Flowable::fromPublisher, publisherCount).groupBy(MarshallableEntry::getMetadata).flatMapCompletable(meFlowable -> meFlowable.buffer(this.configuration.maxBatchSize()).flatMapCompletable(meList -> {
            Map<Object, Object> map = meList.stream().collect(Collectors.toMap(this::getKey, this::getValue));
            Metadata metadata = (Metadata)meFlowable.getKey();
            long lifespan = metadata != null ? this.toSeconds(metadata.lifespan(), "batch", LIFESPAN) : -1L;
            long maxIdle = metadata != null ? this.toSeconds(metadata.maxIdle(), "batch", MAXIDLE) : -1L;
            return Completable.fromCompletionStage((CompletionStage)this.remoteCache.putAllAsync(map, lifespan, TimeUnit.SECONDS, maxIdle, TimeUnit.SECONDS));
        }));
        return removeCompletable.mergeWith((CompletableSource)putCompletable).toCompletionStage(null);
    }

    public CompletionStage<Void> clear() {
        return this.remoteCache.clearAsync();
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        key = RemoteStore.unwrap(key);
        return this.remoteCache.removeAsync(key).thenApply(v -> null);
    }

    private long toSeconds(long millis, Object key, String desc) {
        if (millis > 0L && millis < 1000L) {
            if (log.isTraceEnabled()) {
                log.tracef("Adjusting %s time for key %s from %d millis to 1 sec, as milliseconds are not supported by HotRod", desc, key, millis);
            }
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    public RemoteCache<Object, Object> getRemoteCache() {
        return this.remoteCache;
    }

    private ConfigurationBuilder buildRemoteConfiguration(RemoteStoreConfiguration configuration, Marshaller marshaller) {
        Properties propertiesToUse;
        Properties actualProperties;
        AuthenticationConfiguration auth;
        ConfigurationBuilder builder = configuration.uri() != null && !configuration.uri().isEmpty() ? HotRodURI.create((String)configuration.uri()).toConfigurationBuilder() : new ConfigurationBuilder();
        List<RemoteServerConfiguration> servers = configuration.servers();
        for (RemoteServerConfiguration s : servers) {
            builder.addServer().host(s.host()).port(s.port());
        }
        ConnectionPoolConfiguration poolConfiguration = configuration.connectionPool();
        Long connectionTimeout = configuration.connectionTimeout();
        Long socketTimeout = configuration.socketTimeout();
        builder.classLoader(((Object)((Object)configuration)).getClass().getClassLoader()).balancingStrategy(configuration.balancingStrategy()).connectionPool().exhaustedAction(ExhaustedAction.valueOf((String)poolConfiguration.exhaustedAction().toString())).maxActive(poolConfiguration.maxActive()).minIdle(poolConfiguration.minIdle()).minEvictableIdleTime(poolConfiguration.minEvictableIdleTime()).connectionTimeout(connectionTimeout.intValue()).forceReturnValues(configuration.forceReturnValues()).keySizeEstimate(configuration.keySizeEstimate()).marshaller(marshaller).asyncExecutorFactory().factoryClass(configuration.asyncExecutorFactory().factory().getClass()).asyncExecutorFactory().withExecutorProperties((Properties)configuration.asyncExecutorFactory().properties()).socketTimeout(socketTimeout.intValue()).tcpNoDelay(configuration.tcpNoDelay()).valueSizeEstimate(configuration.valueSizeEstimate()).version(configuration.protocol() == null ? ProtocolVersion.DEFAULT_PROTOCOL_VERSION : configuration.protocol());
        SslConfiguration ssl = configuration.security().ssl();
        if (ssl.enabled()) {
            builder.security().ssl().enable().keyStoreType(ssl.keyStoreType()).keyAlias(ssl.keyAlias()).keyStoreFileName(ssl.keyStoreFileName()).keyStorePassword(ssl.keyStorePassword()).keyStoreCertificatePassword(ssl.keyStoreCertificatePassword()).trustStoreFileName(ssl.trustStoreFileName()).trustStorePassword(ssl.trustStorePassword()).trustStoreType(ssl.trustStoreType()).protocol(ssl.protocol()).sniHostName(ssl.sniHostName());
        }
        if ((auth = configuration.security().authentication()).enabled()) {
            builder.security().authentication().enable().callbackHandler(auth.callbackHandler()).clientSubject(auth.clientSubject()).saslMechanism(auth.saslMechanism()).serverName(auth.serverName()).saslProperties(auth.saslProperties()).username(auth.username()).password(auth.password()).realm(auth.realm());
        }
        if (!(actualProperties = configuration.properties()).contains("blocking")) {
            propertiesToUse = new Properties(actualProperties);
            propertiesToUse.put("blocking", "false");
        } else {
            propertiesToUse = actualProperties;
        }
        builder.withProperties(propertiesToUse);
        return builder;
    }

    public RemoteStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean ignoreCommandWithFlags(long commandFlags) {
        return EnumUtil.containsAny((long)FlagBitSets.ROLLING_UPGRADE, (long)commandFlags);
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        return super.addSegments(segments);
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        return super.removeSegments(segments);
    }

    private /* synthetic */ void lambda$start$1(InitializationContext ctx, Marshaller marshaller, PingResponse pingResponse) {
        MediaType localValueStorageType;
        boolean segmentsMatch;
        String cacheName = ctx.getCache().getName();
        MediaType serverKeyStorageType = pingResponse.getKeyMediaType();
        MediaType serverValueStorageType = pingResponse.getValueMediaType();
        DataFormat.Builder dataFormatBuilder = DataFormat.builder().from(this.remoteCache.getDataFormat());
        Integer numSegments = this.remoteCache.getCacheTopologyInfo().getNumSegments();
        if (numSegments == null) {
            log.debugf("Remote Store for cache %s cannot support segmentation as the number of segments was not found from the remote cache", cacheName);
            segmentsMatch = false;
        } else {
            boolean bl = segmentsMatch = numSegments == this.segmentCount;
            if (segmentsMatch) {
                log.debugf("Remote Store for cache %s can support segmentation as the number of segments matched the remote cache", cacheName);
            } else {
                log.debugf("Remote Store for cache %s cannot support segmentation as the number of segments %d do not match the remote cache %d", cacheName, this.segmentCount, numSegments);
            }
        }
        if (!segmentsMatch && this.configuration.segmented()) {
            throw log.segmentationRequiresEqualSegments(this.segmentCount, numSegments);
        }
        StorageConfigurationManager storageConfigurationManager = (StorageConfigurationManager)ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(StorageConfigurationManager.class);
        MediaType localKeyStorageType = storageConfigurationManager.getKeyStorageMediaType();
        MediaType mediaType = localValueStorageType = this.configuration.rawValues() ? storageConfigurationManager.getValueStorageMediaType() : MediaType.APPLICATION_OBJECT;
        if ((serverKeyStorageType == null || serverKeyStorageType.match(MediaType.APPLICATION_UNKNOWN)) && localKeyStorageType.isBinary()) {
            dataFormatBuilder.keyMarshaller((Marshaller)IdentityMarshaller.INSTANCE);
        }
        if ((serverValueStorageType == null || serverValueStorageType.match(MediaType.APPLICATION_UNKNOWN)) && localValueStorageType.isBinary()) {
            dataFormatBuilder.valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE);
        }
        this.supportsSegmentation = localKeyStorageType.equals((Object)serverKeyStorageType);
        if (this.supportsSegmentation) {
            dataFormatBuilder.keyType(localKeyStorageType.isBinary() ? localKeyStorageType : marshaller.mediaType());
            dataFormatBuilder.keyMarshaller((Marshaller)(localKeyStorageType.isBinary() ? IdentityMarshaller.INSTANCE : marshaller));
        } else if (this.configuration.segmented()) {
            throw log.segmentationRequiresEqualMediaTypes(localKeyStorageType, serverKeyStorageType);
        }
        if (localValueStorageType.equals((Object)serverValueStorageType)) {
            dataFormatBuilder.valueType(localValueStorageType.isBinary() ? localValueStorageType : marshaller.mediaType());
            dataFormatBuilder.valueMarshaller((Marshaller)(localValueStorageType.isBinary() ? IdentityMarshaller.INSTANCE : marshaller));
        }
        DataFormat dataFormat = dataFormatBuilder.build();
        if (log.isTraceEnabled()) {
            log.tracef("Data format for RemoteStore on cache %s is %s", cacheName, dataFormat);
        }
        this.remoteCache = this.remoteCache.withDataFormat(dataFormat);
    }
}

