/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.json.Json;
import javax.json.JsonObject;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.x500.cert.acme.ElytronMessages;

public final class Acme {
    public static final String ACCOUNT = "account";
    public static final String ALG = "alg";
    public static final String AUTHORIZATION = "authorization";
    public static final String AUTHORIZATIONS = "authorizations";
    public static final String CAA_IDENTITIES = "caaIdentities";
    public static final String CERTIFICATE = "certificate";
    public static final String CHALLENGES = "challenges";
    public static final String CONTACT = "contact";
    public static final String CURVE = "crv";
    public static final String CSR = "csr";
    public static final String DEACTIVATED = "deactivated";
    public static final String DETAIL = "detail";
    public static final String DNS = "dns";
    public static final String EXPONENT = "e";
    public static final String EXTERNAL_ACCOUNT_REQUIRED = "externalAccountRequired";
    public static final String FINALIZE = "finalize";
    public static final String IDENTIFIER = "identifier";
    public static final String IDENTIFIERS = "identifiers";
    public static final String INSTANCE = "instance";
    public static final String INVALID = "invalid";
    public static final String JWK = "jwk";
    public static final String KEY_TYPE = "kty";
    public static final String KID = "kid";
    public static final String META = "meta";
    public static final String MODULUS = "n";
    public static final String NEW_KEY = "newKey";
    public static final String NONCE = "nonce";
    public static final String OLD_KEY = "oldKey";
    public static final String ONLY_RETURN_EXISTING = "onlyReturnExisting";
    public static final String ORDER = "order";
    public static final String PAYLOAD = "payload";
    public static final String PENDING = "pending";
    public static final String PROTECTED = "protected";
    public static final String REASON = "reason";
    public static final String SIGNATURE = "signature";
    public static final String STATUS = "status";
    public static final String SUBPROBLEMS = "subproblems";
    public static final String TERMS_OF_SERVICE = "termsOfService";
    public static final String TERMS_OF_SERVICE_AGREED = "termsOfServiceAgreed";
    public static final String TOKEN = "token";
    public static final String TITLE = "title";
    public static final String TYPE = "type";
    public static final String URL = "url";
    public static final String VALID = "valid";
    public static final String VALUE = "value";
    public static final String WEBSITE = "website";
    public static final String X_COORDINATE = "x";
    public static final String Y_COORDINATE = "y";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String LOCATION = "Location";
    public static final String REPLAY_NONCE = "Replay-Nonce";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String PROBLEM_JSON_CONTENT_TYPE = "application/problem+json";
    public static final String JOSE_JSON_CONTENT_TYPE = "application/jose+json";
    public static final String PEM_CERTIFICATE_CHAIN_CONTENT_TYPE = "application/pem-certificate-chain";
    public static final String USER_AGENT = "User-Agent";
    public static final String ERROR_TYPE_PREFIX = "urn:ietf:params:acme:error:";
    public static final String BAD_NONCE = "urn:ietf:params:acme:error:badNonce";
    public static final String USER_ACTION_REQUIRED = "urn:ietf:params:acme:error:userActionRequired";
    public static final String RATE_LIMITED = "urn:ietf:params:acme:error:rateLimited";
    static final Base64Alphabet BASE64_URL = new Base64Alphabet(false){

        @Override
        public int encode(int val) {
            if (val <= 25) {
                return 65 + val;
            }
            if (val <= 51) {
                return 97 + val - 26;
            }
            if (val <= 61) {
                return 48 + val - 52;
            }
            if (val == 62) {
                return 45;
            }
            assert (val == 63);
            return 95;
        }

        @Override
        public int decode(int codePoint) throws IllegalArgumentException {
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint - 65;
            }
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 97 + 26;
            }
            if (48 <= codePoint && codePoint <= 57) {
                return codePoint - 48 + 52;
            }
            if (codePoint == 45) {
                return 62;
            }
            if (codePoint == 95) {
                return 63;
            }
            return -1;
        }
    };

    static String getAlgHeaderFromSignatureAlgorithm(String signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case "SHA256withRSA": {
                return "RS256";
            }
            case "SHA384withRSA": {
                return "RS384";
            }
            case "SHA512withRSA": {
                return "RS512";
            }
            case "SHA256withECDSA": {
                return "ES256";
            }
            case "SHA384withECDSA": {
                return "ES384";
            }
            case "SHA512withECDSA": {
                return "ES512";
            }
        }
        throw ElytronMessages.acme.unsupportedAcmeAccountSignatureAlgorithm(signatureAlgorithm);
    }

    static JsonObject getJwk(PublicKey publicKey, String algHeader) {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            return Json.createObjectBuilder().add(EXPONENT, Acme.base64UrlEncode(rsaPublicKey.getPublicExponent().toByteArray())).add(KEY_TYPE, "RSA").add(MODULUS, Acme.base64UrlEncode(Acme.modulusToByteArray(rsaPublicKey.getModulus()))).build();
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            int fieldSize = ecPublicKey.getParams().getCurve().getField().getFieldSize();
            return Json.createObjectBuilder().add(CURVE, Acme.getCurveParameterFromAlgHeader(algHeader)).add(KEY_TYPE, "EC").add(X_COORDINATE, Acme.base64UrlEncode(Acme.coordinateToByteArray(fieldSize, ecPublicKey.getW().getAffineX()))).add(Y_COORDINATE, Acme.base64UrlEncode(Acme.coordinateToByteArray(fieldSize, ecPublicKey.getW().getAffineY()))).build();
        }
        throw ElytronMessages.acme.unsupportedAcmeAccountPublicKeyType(publicKey.getAlgorithm());
    }

    private static byte[] modulusToByteArray(BigInteger modulus) {
        byte[] modulusByteArray = modulus.toByteArray();
        if (modulus.bitLength() % 8 == 0 && modulusByteArray[0] == 0 && modulusByteArray.length > 1) {
            return ByteIterator.ofBytes(modulusByteArray, 1, modulusByteArray.length - 1).drain();
        }
        return modulusByteArray;
    }

    private static byte[] coordinateToByteArray(int fieldSize, BigInteger coordinate) {
        byte[] coordinateByteArray = Acme.modulusToByteArray(coordinate);
        int fullSize = (int)Math.ceil((double)fieldSize / 8.0);
        if (fullSize > coordinateByteArray.length) {
            byte[] fullSizeCoordinateByteArray = new byte[fullSize];
            System.arraycopy(coordinateByteArray, 0, fullSizeCoordinateByteArray, fullSize - coordinateByteArray.length, coordinateByteArray.length);
            return fullSizeCoordinateByteArray;
        }
        return coordinateByteArray;
    }

    private static String getCurveParameterFromAlgHeader(String algHeader) {
        switch (algHeader) {
            case "ES256": {
                return "P-256";
            }
            case "ES384": {
                return "P-384";
            }
            case "ES512": {
                return "P-521";
            }
        }
        throw ElytronMessages.acme.unableToDetermineCurveParameterFromAlgHeader(algHeader);
    }

    static String base64UrlEncode(byte[] data) {
        return ByteIterator.ofBytes(data).base64Encode(BASE64_URL, false).drainToString();
    }
}

