/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.RemoteDomainControllerConnectionConfiguration;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionManager;
import org.jboss.as.protocol.ProtocolConnectionUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FutureManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementPingRequest;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.manager.WildFlySecurityManager;

class RemoteDomainConnection
extends FutureManagementChannel {
    private static final String CHANNEL_SERVICE_TYPE = "domain";
    private static final long INTERVAL;
    private static final long TIMEOUT;
    private final String localHostName;
    private final AuthenticationContext authenticationContext;
    private final HostRegistrationCallback callback;
    private final ProtocolConnectionManager connectionManager;
    private final ProtocolConnectionConfiguration configuration;
    private final ManagementChannelHandler channelHandler;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ManagementPongRequestHandler pongHandler = new ManagementPongRequestHandler();
    private final List<DiscoveryOption> discoveryOptions;
    private final RunningMode runningMode;
    private URI uri;

    RemoteDomainConnection(String localHostName, ProtocolConnectionConfiguration configuration, AuthenticationContext authenticationContext, List<DiscoveryOption> discoveryOptions, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, HostRegistrationCallback callback, RunningMode runningMode) {
        this.callback = callback;
        this.localHostName = localHostName;
        this.configuration = configuration;
        this.authenticationContext = authenticationContext;
        this.discoveryOptions = discoveryOptions;
        this.executorService = executorService;
        this.channelHandler = new ManagementChannelHandler((ManagementClientChannelStrategy)this, executorService);
        this.scheduledExecutorService = scheduledExecutorService;
        this.runningMode = runningMode;
        this.connectionManager = ProtocolConnectionManager.create((ProtocolConnectionManager.ConnectTask)new InitialConnectTask());
    }

    protected void connect() throws IOException {
        this.connectionManager.connect();
    }

    protected ManagementChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public Channel getChannel() throws IOException {
        return this.awaitChannel();
    }

    protected void setUri(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.prepareClose() && this.isConnected()) {
                try {
                    this.channelHandler.executeRequest((ManagementRequest)new UnregisterModelControllerRequest(), null).getResult().await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            try {
                super.close();
            }
            finally {
                this.connectionManager.shutdown();
            }
        }
    }

    protected boolean isConnected() {
        return super.isConnected();
    }

    protected Connection openConnection() throws IOException {
        CallbackHandler callbackHandler = null;
        SSLContext sslContext = null;
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy((ProtocolConnectionConfiguration)this.configuration);
        config.setCallbackHandler(callbackHandler);
        config.setSslContext(sslContext);
        config.setUri(this.uri);
        AuthenticationContext authenticationContext = this.authenticationContext != null ? this.authenticationContext : AuthenticationContext.captureCurrent();
        try {
            return (Connection)authenticationContext.run(() -> ProtocolConnectionUtils.connectSync((ProtocolConnectionConfiguration)config));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public void connectionOpened(Connection connection) throws IOException {
        Channel channel = this.openChannel(connection, CHANNEL_SERVICE_TYPE, this.configuration.getOptionMap());
        if (this.setChannel(channel)) {
            channel.receiveMessage(this.channelHandler.getReceiver());
            channel.addCloseHandler((CloseHandler)this.channelHandler);
            try {
                if (this.runningMode == RunningMode.ADMIN_ONLY) {
                    this.channelHandler.executeRequest((ManagementRequest)new FetchDomainConfigurationRequest(), null).getResult().get();
                } else {
                    this.channelHandler.executeRequest((ManagementRequest)new RegisterHostControllerRequest(), null).getResult().get();
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
            this.registered();
        } else {
            channel.closeAsync();
        }
    }

    protected Future<Connection> reconnect() {
        this.channelHandler.getAttachments().removeAttachment(TransactionalProtocolClient.SEND_IDENTITY);
        return this.executorService.submit(new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                ReconnectPolicy reconnectPolicy = ReconnectPolicy.RECONNECT;
                int reconnectionCount = 0;
                while (true) {
                    reconnectPolicy.wait(reconnectionCount);
                    HostControllerLogger.ROOT_LOGGER.reconnectingToMaster();
                    Iterator i = RemoteDomainConnection.this.discoveryOptions.iterator();
                    while (i.hasNext()) {
                        DiscoveryOption discoveryOption = (DiscoveryOption)i.next();
                        URI masterURI = null;
                        try {
                            List<RemoteDomainControllerConnectionConfiguration> remoteDcConfigs = discoveryOption.discover();
                            for (RemoteDomainControllerConnectionConfiguration remoteDcConfig : remoteDcConfigs) {
                                try {
                                    return RemoteDomainConnection.this.connect(remoteDcConfig);
                                }
                                catch (IOException ioe) {
                                    RemoteDomainConnectionService.rethrowIrrecoverableConnectionFailures(ioe);
                                    HostControllerLogger.ROOT_LOGGER.debugf("Failed connecting to DomainController -- %s", ioe);
                                }
                            }
                        }
                        catch (Exception e) {
                            RemoteDomainConnectionService.logConnectionException(masterURI, discoveryOption, i.hasNext(), e);
                        }
                    }
                    ++reconnectionCount;
                }
            }
        });
    }

    private Connection connect(RemoteDomainControllerConnectionConfiguration remoteDcConfig) throws URISyntaxException, IOException, SlaveRegistrationException {
        URI masterURI = new URI(remoteDcConfig.getProtocol(), null, remoteDcConfig.getHost(), remoteDcConfig.getPort(), null, null, null);
        this.setUri(masterURI);
        HostControllerLogger.ROOT_LOGGER.debugf("trying to reconnect to remote host-controller at %s", masterURI);
        Connection connection = this.connectionManager.connect();
        HostControllerLogger.ROOT_LOGGER.connectedToMaster(masterURI);
        return connection;
    }

    ModelNode resolveSubsystemVersions(ModelNode extensions) {
        return this.callback.resolveSubsystemVersions(extensions);
    }

    boolean applyDomainModel(ModelNode result) {
        if (!result.hasDefined("result")) {
            return false;
        }
        List bootOperations = result.get("result").asList();
        return this.callback.applyDomainModel(bootOperations);
    }

    void registered() {
        this.callback.registrationComplete(this.channelHandler);
    }

    private void schedule(PingTask task) {
        this.scheduledExecutorService.schedule(task, INTERVAL, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        long interval = -1L;
        try {
            interval = Long.parseLong(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.domain.ping.interval", (String)"15000"));
            INTERVAL = interval > 0L ? interval : 15000L;
        }
        catch (Exception exception) {
            INTERVAL = interval > 0L ? interval : 15000L;
        }
        catch (Throwable throwable) {
            INTERVAL = interval > 0L ? interval : 15000L;
            throw throwable;
        }
        long timeout = -1L;
        try {
            timeout = Long.parseLong(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.domain.ping.timeout", (String)"30000"));
            TIMEOUT = timeout > 0L ? timeout : 30000L;
        }
        catch (Exception exception) {
            TIMEOUT = timeout > 0L ? timeout : 30000L;
            catch (Throwable throwable) {
                TIMEOUT = timeout > 0L ? timeout : 30000L;
                throw throwable;
            }
        }
    }

    class ReconnectTaskWrapper
    implements ProtocolConnectionManager.ConnectTask {
        private final Future<Connection> connectionFuture;

        ReconnectTaskWrapper(Future<Connection> connectionFuture) {
            this.connectionFuture = connectionFuture;
        }

        public Connection connect() throws IOException {
            return RemoteDomainConnection.this.openConnection();
        }

        public ProtocolConnectionManager.ConnectionOpenHandler getConnectionOpenedHandler() {
            return RemoteDomainConnection.this;
        }

        public ProtocolConnectionManager.ConnectTask connectionClosed() {
            HostControllerLogger.ROOT_LOGGER.lostRemoteDomainConnection();
            return new ReconnectTaskWrapper(RemoteDomainConnection.this.reconnect());
        }

        public void shutdown() {
            this.connectionFuture.cancel(true);
        }
    }

    class InitialConnectTask
    implements ProtocolConnectionManager.ConnectTask {
        InitialConnectTask() {
        }

        public Connection connect() throws IOException {
            return RemoteDomainConnection.this.openConnection();
        }

        public ProtocolConnectionManager.ConnectionOpenHandler getConnectionOpenedHandler() {
            return RemoteDomainConnection.this;
        }

        public ProtocolConnectionManager.ConnectTask connectionClosed() {
            HostControllerLogger.ROOT_LOGGER.lostRemoteDomainConnection();
            return new ReconnectTaskWrapper(RemoteDomainConnection.this.reconnect());
        }

        public void shutdown() {
        }
    }

    private class PingTask
    implements Runnable {
        private Long remoteInstanceID;

        private PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (RemoteDomainConnection.this.isConnected()) {
                boolean fail = false;
                AsyncFuture future = null;
                try {
                    if (System.currentTimeMillis() - RemoteDomainConnection.this.channelHandler.getLastMessageReceivedTime() > INTERVAL) {
                        future = RemoteDomainConnection.this.channelHandler.executeRequest((ManagementRequest)ManagementPingRequest.INSTANCE, null).getResult();
                        Long id = (Long)future.get(TIMEOUT, TimeUnit.MILLISECONDS);
                        if (this.remoteInstanceID != null && !this.remoteInstanceID.equals(id)) {
                            HostControllerLogger.ROOT_LOGGER.masterHostControllerChanged();
                            fail = true;
                        } else {
                            this.remoteInstanceID = id;
                        }
                    }
                }
                catch (IOException e) {
                    HostControllerLogger.ROOT_LOGGER.debug("Caught exception sending ping request", e);
                }
                catch (InterruptedException e) {
                    this.safeCancel((Future<?>)future);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    HostControllerLogger.ROOT_LOGGER.debug("Caught exception sending ping request", e);
                }
                catch (TimeoutException e) {
                    fail = true;
                    this.safeCancel((Future<?>)future);
                    HostControllerLogger.ROOT_LOGGER.masterHostControllerUnreachable(TIMEOUT);
                }
                finally {
                    if (fail) {
                        Channel channel = null;
                        try {
                            channel = RemoteDomainConnection.this.channelHandler.getChannel();
                        }
                        catch (IOException iOException) {}
                        StreamUtils.safeClose(channel);
                    } else {
                        RemoteDomainConnection.this.schedule(this);
                    }
                }
            }
        }

        void safeCancel(Future<?> future) {
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    private class UnregisterModelControllerRequest
    extends AbstractManagementRequest<Void, Void> {
        private UnregisterModelControllerRequest() {
        }

        public byte getOperationType() {
            return 83;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnection.this.localHostName);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            HostControllerLogger.ROOT_LOGGER.unregisteredAtRemoteHostController();
            resultHandler.done(null);
        }
    }

    private class CompleteRegistrationRequest
    extends AbstractManagementRequest<Void, Void> {
        private final byte outcome;
        private final String message = "yay!";

        private CompleteRegistrationRequest(byte outcome) {
            this.outcome = outcome;
        }

        public byte getOperationType() {
            return 88;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.writeByte((int)this.outcome);
            output.writeUTF("yay!");
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.failed((Throwable)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.parseCode(errorCode), message));
                return;
            }
            resultHandler.done(null);
        }
    }

    private class RegisterSubsystemsRequest
    extends AbstractManagementRequest<Void, Void> {
        private final ModelNode subsystems;

        private RegisterSubsystemsRequest(ModelNode subsystems) {
            this.subsystems = subsystems;
        }

        public byte getOperationType() {
            return 89;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> registrationResultResultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.writeByte(33);
            this.subsystems.writeExternal((DataOutput)output);
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<Void> context) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.failed((Throwable)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.parseCode(errorCode), message));
                return;
            }
            final ModelNode domainModel = new ModelNode();
            domainModel.readExternal(input);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    if (RemoteDomainConnection.this.applyDomainModel(domainModel)) {
                        RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteRegistrationRequest(33));
                    } else {
                        RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteRegistrationRequest(34));
                        resultHandler.failed((Throwable)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.UNKNOWN, ""));
                    }
                }
            });
        }
    }

    private class FetchDomainConfigurationRequest
    extends HostControllerConnectRequest {
        private FetchDomainConfigurationRequest() {
        }

        public byte getOperationType() {
            return 87;
        }
    }

    private class RegisterHostControllerRequest
    extends HostControllerConnectRequest {
        private RegisterHostControllerRequest() {
        }

        public byte getOperationType() {
            return 81;
        }
    }

    private abstract class HostControllerConnectRequest
    extends AbstractManagementRequest<Void, Void> {
        private HostControllerConnectRequest() {
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnection.this.localHostName);
            ModelNode hostInfo = RemoteDomainConnection.this.callback.createLocalHostInfo();
            hostInfo.get("domain-connection-id").set(RemoteDomainConnection.this.pongHandler.getConnectionId());
            hostInfo.writeExternal((DataOutput)output);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<Void> context) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.failed((Throwable)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.parseCode(errorCode), message));
                return;
            }
            final ModelNode extensions = new ModelNode();
            extensions.readExternal(input);
            if (context.getRequestHeader().getVersion() != 1) {
                RemoteDomainConnection.this.channelHandler.getAttachments().attach(TransactionalProtocolClient.SEND_IDENTITY, (Object)Boolean.TRUE);
            }
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    ModelNode subsystems = RemoteDomainConnection.this.resolveSubsystemVersions(extensions);
                    RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new RegisterSubsystemsRequest(subsystems));
                }
            });
        }
    }

    static interface HostRegistrationCallback {
        public ModelNode resolveSubsystemVersions(ModelNode var1);

        public boolean applyDomainModel(List<ModelNode> var1);

        public void registrationComplete(ManagementChannelHandler var1);

        public ModelNode createLocalHostInfo();
    }
}

