/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.IOException;
import java.util.HashSet;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.containers.IndexedElementContainerAdapter;
import org.infinispan.protostream.containers.IterableElementContainerAdapter;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import protostream.javassist.CannotCompileException;
import protostream.javassist.ClassPool;
import protostream.javassist.CtClass;
import protostream.javassist.CtField;
import protostream.javassist.CtMethod;
import protostream.javassist.CtNewConstructor;
import protostream.javassist.CtNewMethod;
import protostream.javassist.NotFoundException;

final class MarshallerByteCodeGenerator
extends AbstractMarshallerCodeGenerator {
    private static final Log log = Log.LogFactory.getLog(MarshallerByteCodeGenerator.class);
    private static final String MARSHALLER_CLASS_NAME_PREFIX = "___ProtostreamGeneratedMarshaller_";
    private static long nextId = 0L;
    private final ClassPool cp;
    private final CtClass ioExceptionClass;
    private final CtClass enumMarshallerInterface;
    private final CtClass protoStreamMarshallerInterface;
    private final CtClass indexedContainerAdapterInterface;
    private final CtClass iterableContainerAdapterInterface;
    private final CtClass generatedMarshallerBaseClass;
    private final CtClass baseMarshallerDelegateClass;
    private final CtClass enumMarshallerDelegateClass;
    private final CtMethod readMethod;
    private final CtMethod writeMethod;
    private final CtMethod decodeMethod;
    private final CtMethod encodeMethod;

    MarshallerByteCodeGenerator(XTypeFactory typeFactory, String protobufSchemaPackage, ClassPool cp) throws NotFoundException {
        super(typeFactory, protobufSchemaPackage);
        this.cp = cp;
        this.ioExceptionClass = cp.getCtClass(IOException.class.getName());
        this.enumMarshallerInterface = cp.getCtClass(EnumMarshaller.class.getName());
        this.protoStreamMarshallerInterface = cp.getCtClass(ProtobufTagMarshaller.class.getName());
        this.indexedContainerAdapterInterface = cp.getCtClass(IndexedElementContainerAdapter.class.getName());
        this.iterableContainerAdapterInterface = cp.getCtClass(IterableElementContainerAdapter.class.getName());
        this.generatedMarshallerBaseClass = cp.getCtClass(GeneratedMarshallerBase.class.getName());
        this.baseMarshallerDelegateClass = cp.getCtClass(BaseMarshallerDelegate.class.getName());
        this.enumMarshallerDelegateClass = cp.getCtClass(EnumMarshallerDelegate.class.getName());
        String readContextName = ProtobufTagMarshaller.ReadContext.class.getName().replace('.', '/');
        String writeContextName = ProtobufTagMarshaller.WriteContext.class.getName().replace('.', '/');
        this.readMethod = this.protoStreamMarshallerInterface.getMethod("read", "(L" + readContextName + ";)Ljava/lang/Object;");
        this.writeMethod = this.protoStreamMarshallerInterface.getMethod("write", "(L" + writeContextName + ";Ljava/lang/Object;)V");
        this.decodeMethod = this.enumMarshallerInterface.getMethod("decode", "(I)Ljava/lang/Enum;");
        this.encodeMethod = this.enumMarshallerInterface.getMethod("encode", "(Ljava/lang/Enum;)I");
    }

    private static synchronized long nextMarshallerClassId() {
        return nextId++;
    }

    private static String makeUniqueMarshallerClassName() {
        return MARSHALLER_CLASS_NAME_PREFIX + MarshallerByteCodeGenerator.nextMarshallerClassId();
    }

    @Override
    public void generateMarshaller(SerializationContext serializationContext, ProtoTypeMetadata ptm) throws Exception {
        Class marshallerClass = null;
        if (ptm instanceof ProtoMessageTypeMetadata) {
            marshallerClass = this.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
        } else if (ptm instanceof ProtoEnumTypeMetadata) {
            marshallerClass = this.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
        }
        if (marshallerClass != null) {
            BaseMarshaller marshaller = marshallerClass.newInstance();
            serializationContext.registerMarshaller(marshaller);
        }
    }

    private Class<EnumMarshaller> generateEnumMarshaller(ProtoEnumTypeMetadata petm) throws NotFoundException, CannotCompileException {
        String marshallerClassName = MarshallerByteCodeGenerator.makeUniqueMarshallerClassName();
        CtClass annotatedClass = this.cp.get(petm.getAnnotatedClass().getName());
        CtClass marshallerImpl = annotatedClass.makeNestedClass(marshallerClassName, true);
        if (log.isTraceEnabled()) {
            log.tracef("Generating enum marshaller %s for %s", marshallerImpl.getName(), petm.getJavaClass().getName());
        }
        marshallerImpl.addInterface(this.enumMarshallerInterface);
        marshallerImpl.setModifiers(marshallerImpl.getModifiers() & 0xFFFFFBFF | 0x10);
        marshallerImpl.addMethod(CtNewMethod.make("public final Class getJavaClass() { return " + petm.getJavaClassName() + ".class; }", marshallerImpl));
        marshallerImpl.addMethod(CtNewMethod.make("public final String getTypeName() { return \"" + this.makeQualifiedTypeName(petm.getFullName()) + "\"; }", marshallerImpl));
        CtMethod ctDecodeMethod = new CtMethod(this.decodeMethod, marshallerImpl, null);
        ctDecodeMethod.setModifiers(ctDecodeMethod.getModifiers() | 0x10);
        String decodeSrc = this.generateEnumDecodeMethodBody(petm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctDecodeMethod.getLongName(), decodeSrc);
        }
        ctDecodeMethod.setBody(decodeSrc);
        marshallerImpl.addMethod(ctDecodeMethod);
        CtMethod ctEncodeMethod = new CtMethod(this.encodeMethod, marshallerImpl, null);
        ctEncodeMethod.setModifiers(ctEncodeMethod.getModifiers() | 0x10);
        String encodeSrc = this.generateEnumEncodeMethodBody(petm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctEncodeMethod.getLongName(), encodeSrc);
        }
        ctEncodeMethod.setBody(encodeSrc);
        marshallerImpl.addMethod(ctEncodeMethod);
        Class<EnumMarshaller> generatedMarshallerClass = this.toClass(marshallerImpl, petm.getAnnotatedClass());
        marshallerImpl.detach();
        return generatedMarshallerClass;
    }

    private Class<?> toClass(CtClass marshallerImpl, XClass petm) throws CannotCompileException {
        if (System.getProperty("java.version").startsWith("1.8")) {
            return marshallerImpl.toClass();
        }
        return marshallerImpl.toClass(petm.asClass());
    }

    private Class<ProtobufTagMarshaller> generateMessageMarshaller(ProtoMessageTypeMetadata pmtm) throws NotFoundException, CannotCompileException {
        String marshallerClassName = MarshallerByteCodeGenerator.makeUniqueMarshallerClassName();
        CtClass annotatedClass = this.cp.get(pmtm.getAnnotatedClass().getName());
        CtClass marshallerImpl = annotatedClass.makeNestedClass(marshallerClassName, true);
        if (log.isTraceEnabled()) {
            log.tracef("Generating message marshaller %s for %s", marshallerImpl.getName(), pmtm.getJavaClass().getName());
        }
        marshallerImpl.addInterface(this.protoStreamMarshallerInterface);
        marshallerImpl.setSuperclass(this.generatedMarshallerBaseClass);
        marshallerImpl.setModifiers(marshallerImpl.getModifiers() & 0xFFFFFBFF | 0x10);
        if (pmtm.isAdapter()) {
            this.addAdapterField(marshallerImpl, pmtm);
        }
        if (pmtm.isIndexedContainer()) {
            marshallerImpl.addInterface(this.indexedContainerAdapterInterface);
            if (pmtm.isAdapter()) {
                marshallerImpl.addMethod(CtNewMethod.make("public final int getNumElements(java.lang.Object container) { return __a$.getNumElements(container); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final java.lang.Object getElement(java.lang.Object container, int index) { return __a$.getElement(container, index); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final void setElement(java.lang.Object container, int index, java.lang.Object element) { __a$.setElement(container, index, element); }", marshallerImpl));
            } else {
                marshallerImpl.addMethod(CtNewMethod.make("public final int getNumElements(java.lang.Object container) { return ((" + this.indexedContainerAdapterInterface.getName() + ") container).getNumElements(); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final java.lang.Object getElement(java.lang.Object container, int index) { return ((" + this.indexedContainerAdapterInterface.getName() + ") container).getElement(index); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final void setElement(java.lang.Object container, int index, java.lang.Object element) { ((" + this.indexedContainerAdapterInterface.getName() + ") container).setElement(index, element); }", marshallerImpl));
            }
        } else if (pmtm.isIterableContainer()) {
            marshallerImpl.addInterface(this.iterableContainerAdapterInterface);
            if (pmtm.isAdapter()) {
                marshallerImpl.addMethod(CtNewMethod.make("public final int getNumElements(java.lang.Object container) { return __a$.getNumElements(container); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final java.util.Iterator getElements(java.lang.Object container) { return __a$.getElements(container); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final void appendElement(java.lang.Object container, java.lang.Object element) { __a$.appendElement(container, element); }", marshallerImpl));
            } else {
                marshallerImpl.addMethod(CtNewMethod.make("public final int getNumElements(java.lang.Object container) { return ((" + this.iterableContainerAdapterInterface.getName() + ") container).getNumElements(); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final java.util.Iterator getElements(java.lang.Object container) { return ((" + this.iterableContainerAdapterInterface.getName() + ") container).getElements(); }", marshallerImpl));
                marshallerImpl.addMethod(CtNewMethod.make("public final void appendElement(java.lang.Object container, java.lang.Object element) { ((" + this.iterableContainerAdapterInterface.getName() + ") container).appendElement(element); }", marshallerImpl));
            }
        }
        this.addMarshallerDelegateFields(marshallerImpl, pmtm);
        marshallerImpl.addMethod(CtNewMethod.make("public final Class getJavaClass() { return " + pmtm.getJavaClass().getCanonicalName() + ".class; }", marshallerImpl));
        marshallerImpl.addMethod(CtNewMethod.make("public final String getTypeName() { return \"" + this.makeQualifiedTypeName(pmtm.getFullName()) + "\"; }", marshallerImpl));
        CtMethod ctReadMethod = new CtMethod(this.readMethod, marshallerImpl, null);
        ctReadMethod.setExceptionTypes(new CtClass[]{this.ioExceptionClass});
        ctReadMethod.setModifiers(ctReadMethod.getModifiers() | 0x10);
        String readBody = this.generateReadMethodBody(pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctReadMethod.getLongName(), readBody);
        }
        ctReadMethod.setBody(readBody);
        marshallerImpl.addMethod(ctReadMethod);
        CtMethod ctWriteMethod = new CtMethod(this.writeMethod, marshallerImpl, null);
        ctWriteMethod.setExceptionTypes(new CtClass[]{this.ioExceptionClass});
        ctWriteMethod.setModifiers(ctWriteMethod.getModifiers() | 0x10);
        String writeBody = this.generateWriteMethodBody(pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctWriteMethod.getLongName(), writeBody);
        }
        ctWriteMethod.setBody(writeBody);
        marshallerImpl.addMethod(ctWriteMethod);
        Class<ProtobufTagMarshaller> generatedMarshallerClass = this.toClass(marshallerImpl, pmtm.getAnnotatedClass());
        marshallerImpl.detach();
        return generatedMarshallerClass;
    }

    private void addAdapterField(CtClass marshallerImpl, ProtoMessageTypeMetadata messageTypeMetadata) throws CannotCompileException, NotFoundException {
        CtClass adapterClass = this.cp.getCtClass(messageTypeMetadata.getAnnotatedClass().getName());
        CtField adapterField = new CtField(adapterClass, "__a$", marshallerImpl);
        adapterField.setModifiers(18);
        marshallerImpl.addField(adapterField);
        marshallerImpl.addConstructor(CtNewConstructor.make("public " + marshallerImpl.getSimpleName() + "() { " + "__a$" + " = new " + adapterClass.getName() + "(); }", marshallerImpl));
    }

    private void addMarshallerDelegateFields(CtClass marshallerImpl, ProtoMessageTypeMetadata messageTypeMetadata) throws CannotCompileException {
        HashSet<String> addedFields = new HashSet<String>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            switch (fieldMetadata.getProtobufType()) {
                case GROUP: 
                case MESSAGE: 
                case ENUM: {
                    String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
                    if (!addedFields.add(fieldName)) break;
                    CtField marshallerDelegateField = new CtField(fieldMetadata.getJavaType().isEnum() ? this.enumMarshallerDelegateClass : this.baseMarshallerDelegateClass, fieldName, marshallerImpl);
                    marshallerDelegateField.setModifiers(2);
                    marshallerImpl.addField(marshallerDelegateField);
                }
            }
        }
    }
}

