/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.jboss.as.connector._private.Capabilities;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.datasources.statistics.DataSourceStatisticsService;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.CommonDeploymentService;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertiesService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertiesService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueInjectionService;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.credential.source.CredentialSource;

public abstract class AbstractDataSourceAdd
extends AbstractAddStepHandler {
    private static final ServiceName SECURITY_DOMAIN_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "security-domain"});
    private static final ServiceName SECURITY_MANAGER_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"});
    private static final ServiceName SUBJECT_FACTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "subject-factory"});

    AbstractDataSourceAdd(Collection<AttributeDefinition> attributes) {
        super(Capabilities.DATA_SOURCE_CAPABILITY, attributes);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (context.getProcessType().isServer()) {
            DataSourceStatisticsService.registerStatisticsResources(resource);
        }
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)model.get("credential-reference"), (String)"credential-reference");
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)model.get(Constants.RECOVERY_CREDENTIAL_REFERENCE.getName()), (String)Constants.RECOVERY_CREDENTIAL_REFERENCE.getName());
    }

    protected void performRuntime(final OperationContext context, final ModelNode operation, final ModelNode model) throws OperationFailedException {
        if (model.hasDefined(Constants.AUTHENTICATION_CONTEXT.getName()) && !Constants.ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean()) {
            throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT.getName(), Constants.ELYTRON_ENABLED.getName());
        }
        if (Constants.ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean() && model.hasDefined(Constants.SECURITY_DOMAIN.getName())) {
            throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN.getName(), Constants.ELYTRON_ENABLED.getName());
        }
        boolean enabled = Constants.ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (enabled) {
            this.firstRuntimeStep(context, operation, model);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext operationContext, ModelNode modelNode) throws OperationFailedException {
                    AbstractDataSourceAdd.secondRuntimeStep(context, operation, context.getResourceRegistrationForUpdate(), model, AbstractDataSourceAdd.this.isXa());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)Constants.CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)Constants.RECOVERY_CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    void firstRuntimeStep(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode recoveryCredentialReference;
        String secDomain;
        String jndiName = Constants.JNDI_NAME.resolveModelAttribute(context, model).asString();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        boolean jta = Constants.JTA.resolveModelAttribute(context, operation).asBoolean();
        String dsName = context.getCurrentAddressValue();
        boolean statsEnabled = Constants.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        CapabilityServiceSupport support = context.getCapabilityServiceSupport();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode node = Constants.DATASOURCE_DRIVER.resolveModelAttribute(context, model);
        String driverName = node.asString();
        ServiceName driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        ValueInjectionService driverDemanderService = new ValueInjectionService();
        ServiceName driverDemanderServiceName = ServiceName.JBOSS.append(new String[]{"driver-demander"}).append(new String[]{jndiName});
        ServiceBuilder driverDemanderBuilder = serviceTarget.addService(driverDemanderServiceName, (Service)driverDemanderService).addDependency(driverServiceName, Driver.class, driverDemanderService.getInjector());
        driverDemanderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        AbstractDataSourceService dataSourceService = this.createDataSourceService(dsName, jndiName);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        ServiceName dataSourceServiceNameAlias = AbstractDataSourceService.getServiceName(bindInfo);
        ServiceName dataSourceServiceName = context.getCapabilityServiceName("org.wildfly.data-source", dsName, DataSource.class);
        ServiceBuilder dataSourceServiceBuilder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService), dataSourceService.getExecutorServiceInjector()).addAliases(new ServiceName[]{dataSourceServiceNameAlias}).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector());
        dataSourceServiceBuilder.requires(ConnectorServices.IDLE_REMOVER_SERVICE);
        dataSourceServiceBuilder.requires(ConnectorServices.CONNECTION_VALIDATOR_SERVICE);
        dataSourceServiceBuilder.addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, dataSourceService.getMdrInjector());
        dataSourceServiceBuilder.requires(support.getCapabilityServiceName("org.wildfly.naming"));
        if (jta) {
            dataSourceServiceBuilder.addDependency(support.getCapabilityServiceName("org.wildfly.jca.transaction-integration"), TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector());
            dataSourceServiceBuilder.addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector());
            dataSourceServiceBuilder.requires(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
            dataSourceServiceBuilder.addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, dataSourceService.getRaRepositoryInjector());
        } else {
            dataSourceServiceBuilder.addDependency(ConnectorServices.NON_JTA_DS_RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, dataSourceService.getRaRepositoryInjector()).addDependency(ConnectorServices.NON_TX_CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector());
        }
        if (registration.isAllowsOverride()) {
            registration.registerOverrideModel(dsName, DataSourcesSubsystemProviders.OVERRIDE_DS_DESC);
        }
        this.startConfigAndAddDependency(dataSourceServiceBuilder, dataSourceService, dsName, serviceTarget, operation);
        dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        boolean requireLegacySecurity = false;
        if (Constants.ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean()) {
            if (model.hasDefined(Constants.AUTHENTICATION_CONTEXT.getName())) {
                dataSourceServiceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.authentication-context", Constants.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model).asString(), AuthenticationContext.class), AuthenticationContext.class, dataSourceService.getAuthenticationContext());
            }
        } else {
            secDomain = Constants.SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
            boolean bl = requireLegacySecurity = secDomain != null && secDomain.length() > 0;
        }
        if (this.isXa()) {
            if (Constants.RECOVERY_ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean()) {
                if (model.hasDefined(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName())) {
                    dataSourceServiceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.authentication-context", Constants.RECOVERY_AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model).asString(), AuthenticationContext.class), AuthenticationContext.class, dataSourceService.getRecoveryAuthenticationContext());
                }
            } else if (!requireLegacySecurity) {
                secDomain = Constants.RECOVERY_SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
                boolean bl = requireLegacySecurity = secDomain != null && secDomain.length() > 0;
            }
        }
        if (requireLegacySecurity) {
            context.setRollbackOnly();
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotAvailable(dsName);
        }
        ModelNode credentialReference = Constants.CREDENTIAL_REFERENCE.resolveModelAttribute(context, model);
        if (credentialReference.isDefined()) {
            dataSourceService.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)Constants.CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)dataSourceServiceBuilder));
        }
        if ((recoveryCredentialReference = Constants.RECOVERY_CREDENTIAL_REFERENCE.resolveModelAttribute(context, model)).isDefined()) {
            dataSourceService.getRecoveryCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)Constants.RECOVERY_CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)dataSourceServiceBuilder));
        }
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.NEVER);
        dataSourceServiceBuilder.install();
        driverDemanderBuilder.install();
    }

    static void secondRuntimeStep(OperationContext context, ModelNode operation, ManagementResourceRegistration datasourceRegistration, ModelNode model, boolean isXa) throws OperationFailedException {
        DsSecurity dsSecurityConfig;
        ServiceBuilder builder;
        Object dataSourceConfig;
        boolean jta;
        ExceptionSupplier recoveryCredentialSourceExceptionExceptionSupplier;
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        final String jndiName = Constants.JNDI_NAME.resolveModelAttribute(context, model).asString();
        ServiceRegistry registry = context.getServiceRegistry(true);
        List serviceNames = registry.getServiceNames();
        boolean elytronEnabled = Constants.ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean();
        ServiceName dataSourceServiceName = context.getCapabilityServiceName("org.wildfly.data-source", dsName, DataSource.class);
        ServiceController dataSourceController = registry.getService(dataSourceServiceName);
        ExceptionSupplier credentialSourceExceptionExceptionSupplier = dataSourceController.getService() instanceof AbstractDataSourceService ? (ExceptionSupplier)((AbstractDataSourceService)dataSourceController.getService()).getCredentialSourceSupplierInjector().getOptionalValue() : null;
        ExceptionSupplier exceptionSupplier = recoveryCredentialSourceExceptionExceptionSupplier = dataSourceController.getService() instanceof AbstractDataSourceService ? (ExceptionSupplier)((AbstractDataSourceService)dataSourceController.getService()).getRecoveryCredentialSourceSupplierInjector().getOptionalValue() : null;
        if (isXa) {
            Credential credential;
            jta = true;
            try {
                dataSourceConfig = DataSourceModelNodeUtil.xaFrom(context, model, dsName, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceExceptionExceptionSupplier, (ExceptionSupplier<CredentialSource, Exception>)recoveryCredentialSourceExceptionExceptionSupplier);
            }
            catch (ValidateException e) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToCreate("XaDataSource", operation, e.getLocalizedMessage()));
            }
            ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            XADataSourceConfigService xaDataSourceConfigService = new XADataSourceConfigService((ModifiableXaDataSource)((Object)dataSourceConfig));
            builder = serviceTarget.addService(xaDataSourceConfigServiceName, (Service)xaDataSourceConfigService);
            dsSecurityConfig = dataSourceConfig.getSecurity();
            if (dsSecurityConfig != null) {
                String securityDomainName = dsSecurityConfig.getSecurityDomain();
                if (!elytronEnabled && securityDomainName != null) {
                    builder.requires(SECURITY_DOMAIN_SERVICE.append(new String[]{securityDomainName}));
                }
            }
            if (dataSourceConfig.getRecovery() != null && (credential = dataSourceConfig.getRecovery().getCredential()) != null) {
                String securityDomainName = credential.getSecurityDomain();
                if (!Constants.RECOVERY_ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean() && securityDomainName != null) {
                    builder.requires(SECURITY_DOMAIN_SERVICE.append(new String[]{securityDomainName}));
                }
            }
            int propertiesCount = 0;
            for (ServiceName name : serviceNames) {
                if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
                ServiceController xaConfigPropertyController = registry.getService(name);
                XaDataSourcePropertiesService xaPropService = (XaDataSourcePropertiesService)xaConfigPropertyController.getService();
                if (!ServiceController.State.UP.equals((Object)xaConfigPropertyController.getState())) {
                    ++propertiesCount;
                    xaConfigPropertyController.setMode(ServiceController.Mode.ACTIVE);
                    builder.addDependency(name, String.class, xaDataSourceConfigService.getXaDataSourcePropertyInjector(xaPropService.getName()));
                    continue;
                }
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source.xa-config-property", name));
            }
            if (propertiesCount == 0) {
                throw ConnectorLogger.ROOT_LOGGER.xaDataSourcePropertiesNotPresent();
            }
            builder.install();
        } else {
            try {
                dataSourceConfig = DataSourceModelNodeUtil.from(context, model, dsName, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceExceptionExceptionSupplier);
            }
            catch (ValidateException e) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToCreate("DataSource", operation, e.getLocalizedMessage()));
            }
            jta = dataSourceConfig.isJTA();
            ServiceName dataSourceCongServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            DataSourceConfigService configService = new DataSourceConfigService((ModifiableDataSource)((Object)dataSourceConfig));
            builder = serviceTarget.addService(dataSourceCongServiceName, (Service)configService);
            dsSecurityConfig = dataSourceConfig.getSecurity();
            if (dsSecurityConfig != null) {
                String securityDomainName = dsSecurityConfig.getSecurityDomain();
                if (!elytronEnabled && securityDomainName != null) {
                    builder.requires(SECURITY_DOMAIN_SERVICE.append(new String[]{securityDomainName}));
                }
            }
            for (ServiceName name : serviceNames) {
                if (!dataSourceCongServiceName.append(new String[]{"connection-properties"}).isParentOf(name)) continue;
                ServiceController connPropServiceController = registry.getService(name);
                ConnectionPropertiesService connPropService = (ConnectionPropertiesService)connPropServiceController.getService();
                if (!ServiceController.State.UP.equals((Object)connPropServiceController.getState())) {
                    connPropServiceController.setMode(ServiceController.Mode.ACTIVE);
                    builder.addDependency(name, String.class, configService.getConnectionPropertyInjector(connPropService.getName()));
                    continue;
                }
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source.connectionProperty", name));
            }
            builder.install();
        }
        ServiceName dataSourceServiceNameAlias = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}).append(new String[]{"statistics"});
        if (dataSourceController != null) {
            if (ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source", dsName));
            }
        } else {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceNotAvailable("Data-source", dsName));
        }
        boolean statsEnabled = Constants.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        DataSourceStatisticsService statsService = new DataSourceStatisticsService(datasourceRegistration, statsEnabled);
        ServiceBuilder statsServiceSB = serviceTarget.addService(dataSourceServiceName.append(new String[]{"statistics"}), (Service)statsService);
        statsServiceSB.addAliases(new ServiceName[]{dataSourceServiceNameAlias});
        statsServiceSB.requires(dataSourceServiceName);
        statsServiceSB.addDependency(CommonDeploymentService.getServiceName(ContextNames.bindInfoFor((String)jndiName)), CommonDeployment.class, statsService.getCommonDeploymentInjector());
        statsServiceSB.setInitialMode(ServiceController.Mode.PASSIVE);
        statsServiceSB.install();
        dataSourceController.setMode(ServiceController.Mode.ACTIVE);
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName});
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        referenceBuilder.install();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<? extends Object> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        if (jta) {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(jndiName);
                        } else {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundNonJTADataSource(jndiName);
                        }
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        if (jta) {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(jndiName);
                            break;
                        }
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unBoundNonJTADataSource(jndiName);
                        break;
                    }
                    case REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", jndiName);
                    }
                }
            }
        });
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        binderBuilder.install();
    }

    protected abstract void startConfigAndAddDependency(ServiceBuilder<?> var1, AbstractDataSourceService var2, String var3, ServiceTarget var4, ModelNode var5) throws OperationFailedException;

    protected abstract AbstractDataSourceService createDataSourceService(String var1, String var2) throws OperationFailedException;

    protected abstract boolean isXa();

    static Collection<AttributeDefinition> join(AttributeDefinition[] a, AttributeDefinition[] b) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        result.addAll(Arrays.asList(a));
        result.addAll(Arrays.asList(b));
        return result;
    }
}

