/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.jboss.as.connector.deployers.Util;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.metadata.spec.RaParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class RaDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        boolean resolveProperties = Util.shouldResolveSpec(deploymentUnit);
        VirtualFile file = deploymentRoot.getRoot();
        if (file == null || !file.exists()) {
            return;
        }
        String deploymentRootName = file.getName().toLowerCase(Locale.ENGLISH);
        if (!deploymentRootName.endsWith(".rar")) {
            return;
        }
        VirtualFile alternateDescriptor = (VirtualFile)deploymentRoot.getAttachment(org.jboss.as.ee.structure.Attachments.ALTERNATE_CONNECTOR_DEPLOYMENT_DESCRIPTOR);
        String prefix = "";
        if (deploymentUnit.getParent() != null) {
            prefix = deploymentUnit.getParent().getName() + "#";
        }
        String deploymentName = prefix + file.getName();
        ConnectorXmlDescriptor xmlDescriptor = RaDeploymentParsingProcessor.process(resolveProperties, file, alternateDescriptor, deploymentName);
        phaseContext.getDeploymentUnit().putAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
    }

    public static ConnectorXmlDescriptor process(boolean resolveProperties, VirtualFile file, VirtualFile alternateDescriptor, String deploymentName) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor;
        VirtualFile serviceXmlFile = alternateDescriptor != null ? alternateDescriptor : file.getChild("/META-INF/ra.xml");
        InputStream xmlStream = null;
        Connector result = null;
        try {
            if (serviceXmlFile != null && serviceXmlFile.exists()) {
                xmlStream = serviceXmlFile.openStream();
                RaParser raParser = new RaParser();
                raParser.setSystemPropertiesResolved(resolveProperties);
                result = raParser.parse(xmlStream);
                if (result == null) {
                    throw ConnectorLogger.ROOT_LOGGER.failedToParseServiceXml(serviceXmlFile);
                }
            }
            File root = file.getPhysicalFile();
            URL url = root.toURI().toURL();
            connectorXmlDescriptor = new ConnectorXmlDescriptor(result, root, url, deploymentName);
        }
        catch (Exception e) {
            try {
                throw ConnectorLogger.ROOT_LOGGER.failedToParseServiceXml(e, serviceXmlFile);
            }
            catch (Throwable throwable) {
                VFSUtils.safeClose(xmlStream);
                throw throwable;
            }
        }
        VFSUtils.safeClose((Closeable)xmlStream);
        return connectorXmlDescriptor;
    }
}

