/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalizableExternalizer<T extends Externalizable>
implements Externalizer<T> {
    private final Class<T> targetClass;

    public ExternalizableExternalizer(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        object.writeExternal(output);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
                return (Externalizable)ExternalizableExternalizer.this.getTargetClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        };
        try {
            Externalizable object = (Externalizable)WildFlySecurityManager.doChecked((PrivilegedExceptionAction)action);
            object.readExternal(input);
            return (T)object;
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getCause());
        }
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

