/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingSubsystemParser_1_0;
import org.jboss.as.logging.handlers.CustomHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_1_1
extends LoggingSubsystemParser_1_0 {
    LoggingSubsystemParser_1_1() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        operations.add(Util.createAddOperation((PathAddress)SUBSYSTEM_ADDRESS));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean rootDefined = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    this.parseLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations, loggerNames);
                    continue block10;
                }
                case ROOT_LOGGER: {
                    if (rootDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    rootDefined = true;
                    this.parseRootLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations);
                    continue block10;
                }
                case CONSOLE_HANDLER: {
                    this.parseConsoleHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block10;
                }
                case FILE_HANDLER: {
                    this.parseFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block10;
                }
                case CUSTOM_HANDLER: {
                    this.parseCustomHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block10;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block10;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block10;
                }
                case ASYNC_HANDLER: {
                    this.parseAsyncHandlerElement(reader, SUBSYSTEM_ADDRESS, asyncHandlerOperations, handlerNames);
                    continue block10;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    void parseCustomHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_1.addOperationAddress(operation, address, "custom-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_1.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_1.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_1.parseFilter(operation, (AttributeDefinition)CustomHandlerResourceDefinition.FILTER_SPEC, reader);
                    continue block13;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block13;
                }
                case PROPERTIES: {
                    LoggingSubsystemParser_1_1.parsePropertyElement(operation, reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }
}

