/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyInfo;
import org.infinispan.xsite.irac.IracManagerKeyInfoImpl;

public class IracCleanupKeysCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 122;
    private ByteString cacheName;
    private Collection<? extends IracManagerKeyInfo> cleanup;

    public IracCleanupKeysCommand() {
    }

    public IracCleanupKeysCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracCleanupKeysCommand(ByteString cacheName, Collection<? extends IracManagerKeyInfo> cleanup) {
        this.cacheName = cacheName;
        this.cleanup = cleanup;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    public CompletableFuture<Object> invokeAsync(ComponentRegistry componentRegistry) {
        IracManager manager = componentRegistry.getIracManager().running();
        this.cleanup.forEach(manager::removeState);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 122;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.cleanup, (ObjectOutput)output, IracManagerKeyInfoImpl::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cleanup = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new, IracManagerKeyInfoImpl::readFrom);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracCleanupKeyCommand{cacheName=" + this.cacheName + ", cleanup=" + Util.toStr(this.cleanup) + '}';
    }
}

