/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi.transactional;

import com.arjuna.ats.jta.cdi.RunnableWithException;
import com.arjuna.ats.jta.cdi.SneakyThrow;
import com.arjuna.ats.jta.cdi.TransactionExtension;
import com.arjuna.ats.jta.cdi.TransactionHandler;
import com.arjuna.ats.jta.cdi.async.ContextPropagationAsyncHandler;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.jboss.tm.usertx.UserTransactionOperationsProvider;

public abstract class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WELD_INTERCEPTOR_BINDINGS_KEY = "org.jboss.weld.interceptor.bindings";
    @Inject
    transient BeanManager beanManager;
    @Inject
    private TransactionExtension extension;
    @Inject
    @Intercepted
    private Bean<?> interceptedBean;
    @Inject
    private TransactionManager transactionManager;
    private final boolean userTransactionAvailable;

    protected TransactionalInterceptorBase(boolean userTransactionAvailable) {
        this.userTransactionAvailable = userTransactionAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InvocationContext ic) throws Exception {
        Transaction tx2 = this.transactionManager.getTransaction();
        boolean previousUserTransactionAvailability = this.setUserTransactionAvailable(this.userTransactionAvailable);
        try {
            Object object = this.doIntercept(this.transactionManager, tx2, ic);
            return object;
        }
        finally {
            this.resetUserTransactionAvailability(previousUserTransactionAvailability);
        }
    }

    protected abstract Object doIntercept(TransactionManager var1, Transaction var2, InvocationContext var3) throws Exception;

    private Transactional getTransactional(InvocationContext ic) {
        if (this.interceptedBean != null && ic.getContextData().get(WELD_INTERCEPTOR_BINDINGS_KEY) != null) {
            Set annotationBindings = (Set)ic.getContextData().get(WELD_INTERCEPTOR_BINDINGS_KEY);
            for (Object annotation : annotationBindings) {
                if (annotation.annotationType() != Transactional.class) continue;
                return (Transactional)annotation;
            }
        }
        if (this.interceptedBean != null) {
            AnnotatedType<?> currentAnnotatedType = this.extension.getBeanToAnnotatedTypeMapping().get(this.interceptedBean);
            if (currentAnnotatedType == null) {
                throw new IllegalStateException(jtaLogger.i18NLogger.get_not_supported_non_weld_interception(this.interceptedBean.getName()));
            }
            AnnotatedMethod currentAnnotatedMethod = null;
            for (AnnotatedMethod methodInSearch : currentAnnotatedType.getMethods()) {
                if (!methodInSearch.getJavaMember().equals(ic.getMethod())) continue;
                currentAnnotatedMethod = methodInSearch;
                break;
            }
            assert (currentAnnotatedMethod != null);
            Transactional transactionalMethod = this.getTransactionalAnnotationRecursive(currentAnnotatedMethod.getAnnotations());
            if (transactionalMethod != null) {
                return transactionalMethod;
            }
            Transactional transactionalExtension = this.getTransactionalAnnotationRecursive(currentAnnotatedType.getAnnotations());
            if (transactionalExtension != null) {
                return transactionalExtension;
            }
            for (Class stereotype : this.interceptedBean.getStereotypes()) {
                Transactional transactionalAnn = stereotype.getAnnotation(Transactional.class);
                if (transactionalAnn == null) continue;
                return transactionalAnn;
            }
        } else {
            Transactional transactional = ic.getMethod().getAnnotation(Transactional.class);
            if (transactional != null) {
                return transactional;
            }
            Class<?> targetClass = ic.getTarget().getClass();
            transactional = targetClass.getAnnotation(Transactional.class);
            if (transactional != null) {
                return transactional;
            }
        }
        throw new RuntimeException(jtaLogger.i18NLogger.get_expected_transactional_annotation());
    }

    private Transactional getTransactionalAnnotationRecursive(Annotation ... annotationsOnMember) {
        if (annotationsOnMember == null) {
            return null;
        }
        HashSet<Class<? extends Annotation>> stereotypeAnnotations = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : annotationsOnMember) {
            if (annotation.annotationType().equals(Transactional.class)) {
                return (Transactional)annotation;
            }
            if (!this.beanManager.isStereotype(annotation.annotationType())) continue;
            stereotypeAnnotations.add(annotation.annotationType());
        }
        Iterator iterator = stereotypeAnnotations.iterator();
        if (iterator.hasNext()) {
            Class stereotypeAnnotation = (Class)iterator.next();
            return this.getTransactionalAnnotationRecursive(this.beanManager.getStereotypeDefinition(stereotypeAnnotation));
        }
        return null;
    }

    private Transactional getTransactionalAnnotationRecursive(Set<Annotation> annotationsOnMember) {
        return this.getTransactionalAnnotationRecursive(annotationsOnMember.toArray(new Annotation[0]));
    }

    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm) throws Exception {
        return this.invokeInOurTx(ic, tm, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm, RunnableWithException afterEndTransaction) throws Exception {
        tm.begin();
        Transaction tx2 = tm.getTransaction();
        boolean throwing = false;
        Object ret = null;
        try {
            ret = ic.proceed();
        }
        catch (Throwable e) {
            throwing = true;
            this.handleException(ic, e, tx2);
        }
        finally {
            AtomicReference<Object> retRef = new AtomicReference<Object>(ret);
            boolean asyncReturnType = ContextPropagationAsyncHandler.tryHandleAsynchronously(tm, tx2, this.getTransactional(ic), retRef, ic.getMethod().getReturnType(), afterEndTransaction);
            if (throwing || ret == null || !asyncReturnType) {
                TransactionHandler.endTransaction(tm, tx2, afterEndTransaction);
            }
            if (asyncReturnType) {
                ret = retRef.get();
            }
        }
        return ret;
    }

    protected Object invokeInCallerTx(InvocationContext ic, Transaction tx2) throws Exception {
        try {
            return ic.proceed();
        }
        catch (Throwable t) {
            this.handleException(ic, t, tx2);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    protected void handleException(InvocationContext ic, Throwable t, Transaction tx2) throws Exception {
        TransactionHandler.handleExceptionNoThrow(this.getTransactional(ic), t, tx2);
        SneakyThrow.sneakyThrow(t);
    }

    protected boolean setUserTransactionAvailable(boolean available) {
        UserTransactionOperationsProvider userTransactionProvider = jtaPropertyManager.getJTAEnvironmentBean().getUserTransactionOperationsProvider();
        boolean previousUserTransactionAvailability = userTransactionProvider.getAvailability();
        this.setAvailability(userTransactionProvider, available);
        return previousUserTransactionAvailability;
    }

    protected void resetUserTransactionAvailability(boolean previousUserTransactionAvailability) {
        UserTransactionOperationsProvider userTransactionProvider = jtaPropertyManager.getJTAEnvironmentBean().getUserTransactionOperationsProvider();
        this.setAvailability(userTransactionProvider, previousUserTransactionAvailability);
    }

    private void setAvailability(UserTransactionOperationsProvider userTransactionProvider, boolean available) {
        if (System.getSecurityManager() == null) {
            userTransactionProvider.setAvailability(available);
        } else {
            AccessController.doPrivileged(() -> {
                userTransactionProvider.setAvailability(available);
                return null;
            });
        }
    }
}

