/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.EJBClientDescriptor13Parser;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLAttribute;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLElement;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor14Parser
extends EJBClientDescriptor13Parser {
    public static final String NAMESPACE_1_4 = "urn:jboss:ejb-client:1.4";

    protected EJBClientDescriptor14Parser(PropertyReplacer propertyReplacer) {
        super(propertyReplacer);
    }

    @Override
    protected void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case INVOCATION_TIMEOUT: {
                    Long invocationTimeout = Long.parseLong(value);
                    ejbClientDescriptorMetaData.setInvocationTimeout(invocationTimeout);
                    continue block15;
                }
                case DEPLOYMENT_NODE_SELECTOR: {
                    String deploymentNodeSelector = this.readResolveValue(reader, i);
                    ejbClientDescriptorMetaData.setDeploymentNodeSelector(deploymentNodeSelector);
                    continue block15;
                }
                case DEFAULT_COMPRESSION: {
                    Integer defaultRequestCompression = Integer.parseInt(value);
                    ejbClientDescriptorMetaData.setDefaultCompression(defaultRequestCompression);
                    continue block15;
                }
                default: {
                    EJBClientDescriptor14Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        EnumSet<EJBClientDescriptorXMLElement> visited = EnumSet.noneOf(EJBClientDescriptorXMLElement.class);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor14Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block16;
                        }
                        case HTTP_CONNECTIONS: {
                            this.parseHttpConnections(reader, ejbClientDescriptorMetaData);
                            continue block16;
                        }
                        case CLUSTERS: {
                            this.parseClusters(reader, ejbClientDescriptorMetaData);
                            continue block16;
                        }
                        case PROFILE: {
                            this.parseProfile(reader, ejbClientDescriptorMetaData);
                            continue block16;
                        }
                    }
                    EJBClientDescriptor14Parser.unexpectedElement(reader);
                    continue block16;
                }
            }
            EJBClientDescriptor14Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor14Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseHttpConnections(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case HTTP_CONNECTION: {
                            this.parseHttpConnection(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor14Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor14Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor14Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseHttpConnection(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        String uri = null;
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.URI);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case URI: {
                    uri = value;
                    continue block3;
                }
                default: {
                    EJBClientDescriptor14Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor14Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptor14Parser.requireNoContent(reader);
        ejbClientDescriptorMetaData.addHttpConnectionRef(uri);
    }
}

