/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.HashSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.TrivialService;

abstract class TrivialAddHandler<T>
extends BaseAddHandler {
    private final RuntimeCapability<?> runtimeCapability;
    private final ServiceController.Mode initialMode;
    private final ServiceController.Mode adminOnlyInitialMode;

    TrivialAddHandler(Class<T> serviceType, AttributeDefinition[] attributes, RuntimeCapability<?> runtimeCapability) {
        this(serviceType, ServiceController.Mode.ACTIVE, attributes, runtimeCapability);
    }

    TrivialAddHandler(Class<T> serviceType, ServiceController.Mode initialMode, AttributeDefinition[] attributes, RuntimeCapability<?> runtimeCapability) {
        this(serviceType, initialMode, initialMode, attributes, runtimeCapability);
    }

    TrivialAddHandler(Class<T> serviceType, ServiceController.Mode initialMode, ServiceController.Mode adminOnlyInitialMode, AttributeDefinition[] attributes, RuntimeCapability<?> runtimeCapability) {
        super(new HashSet<Object>(Collections.singletonList(Assert.checkNotNullParam((String)"runtimeCapabilities", runtimeCapability))), attributes);
        this.runtimeCapability = runtimeCapability;
        Assert.checkNotNullParam((String)"serviceType", serviceType);
        this.initialMode = (ServiceController.Mode)Assert.checkNotNullParam((String)"initialMode", (Object)initialMode);
        this.adminOnlyInitialMode = (ServiceController.Mode)Assert.checkNotNullParam((String)"adminOnlyInitialMode", (Object)adminOnlyInitialMode);
    }

    protected final void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        TrivialService<T> trivialService = new TrivialService<T>();
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(this.runtimeCapability);
        serviceBuilder.setInstance(trivialService);
        trivialService.setValueSupplier(this.getValueSupplier((ServiceBuilder<T>)serviceBuilder, context, resource.getModel()));
        this.installedForResource(ElytronDefinition.commonDependencies(serviceBuilder, this.dependOnProperties(), this.dependOnProviderRegistration()).setInitialMode(context.getRunningMode() == RunningMode.ADMIN_ONLY ? this.adminOnlyInitialMode : this.initialMode).install(), resource);
    }

    protected boolean dependOnProperties() {
        return true;
    }

    protected boolean dependOnProviderRegistration() {
        return true;
    }

    protected void installedForResource(ServiceController<T> serviceController, Resource resource) {
    }

    protected abstract TrivialService.ValueSupplier<T> getValueSupplier(ServiceBuilder<T> var1, OperationContext var2, ModelNode var3) throws OperationFailedException;
}

