/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class QuoteServer
extends ReceiverAdapter {
    final Map<String, Float> stocks = new HashMap<String, Float>();
    JChannel channel;
    RpcDispatcher disp;
    static final String channel_name = "Quotes";
    protected Log log = LogFactory.getLog(this.getClass());
    static final String props = null;

    private void integrate(HashMap<String, Float> state) {
        if (state != null) {
            state.keySet().forEach(key -> this.stocks.put((String)key, (Float)state.get(key)));
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("Accepted view (" + new_view.size() + new_view.getMembers() + ')');
    }

    public void start() {
        try {
            this.channel = new JChannel(props);
            this.disp = (RpcDispatcher)new RpcDispatcher(this.channel, this).setMembershipListener(this).setStateListener(this);
            this.channel.connect(channel_name);
            System.out.println("\nQuote Server started at " + new Date());
            System.out.println("Joined channel 'Quotes' (" + this.channel.getView().size() + " members)");
            this.channel.getState(null, 0L);
            System.out.println("Ready to serve requests");
        }
        catch (Exception e) {
            this.log.error("QuoteServer.start() : " + e);
            System.exit(-1);
        }
    }

    public float getQuote(String stock_name) throws Exception {
        System.out.print("Getting quote for " + stock_name + ": ");
        Float retval = this.stocks.get(stock_name);
        if (retval == null) {
            System.out.println("not found");
            throw new Exception("Stock " + stock_name + " not found");
        }
        System.out.println(retval.floatValue());
        return retval.floatValue();
    }

    public void setQuote(String stock_name, Float value) {
        System.out.println("Setting quote for " + stock_name + ": " + value);
        this.stocks.put(stock_name, value);
    }

    public Map<String, Float> getAllStocks() {
        System.out.print("getAllStocks: ");
        this.printAllStocks();
        return this.stocks;
    }

    public void printAllStocks() {
        System.out.println(this.stocks);
    }

    @Override
    public void getState(OutputStream ostream) throws Exception {
        Util.objectToStream(this.stocks, new DataOutputStream(ostream));
    }

    @Override
    public void setState(InputStream istream) throws Exception {
        this.integrate((HashMap)Util.objectFromStream(new DataInputStream(istream)));
    }

    public static void main(String[] args) {
        try {
            QuoteServer server = new QuoteServer();
            server.start();
            while (true) {
                Util.sleep(10000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }
}

