/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.streams.operators.CompletionRunner;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.CompletionRunnerImpl;
import org.eclipse.microprofile.reactive.streams.operators.core.InternalStages;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsEngineResolver;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsGraphBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.Reductions;
import org.eclipse.microprofile.reactive.streams.operators.core.Stages;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class PublisherBuilderImpl<T>
extends ReactiveStreamsGraphBuilder
implements PublisherBuilder<T> {
    PublisherBuilderImpl(Stage stage, ReactiveStreamsGraphBuilder previous) {
        super(stage, previous);
    }

    PublisherBuilderImpl(Stage stage) {
        super(stage, null);
    }

    public <R> PublisherBuilder<R> map(Function<? super T, ? extends R> mapper) {
        return this.addStage((Stage)new Stages.Map(mapper));
    }

    public PublisherBuilder<T> peek(Consumer<? super T> consumer) {
        return this.addStage((Stage)new Stages.Peek(consumer));
    }

    public PublisherBuilder<T> filter(Predicate<? super T> predicate) {
        return this.addStage((Stage)new Stages.Filter(predicate));
    }

    public PublisherBuilder<T> distinct() {
        return this.addStage((Stage)Stages.Distinct.INSTANCE);
    }

    public <S> PublisherBuilder<S> flatMap(Function<? super T, ? extends PublisherBuilder<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMap(mapper.andThen(ReactiveStreamsGraphBuilder::rsBuilderToGraph)));
    }

    public <S> PublisherBuilder<S> flatMapRsPublisher(Function<? super T, ? extends Publisher<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMap(mapper.andThen(ReactiveStreamsGraphBuilder::publisherToGraph)));
    }

    public <S> PublisherBuilder<S> flatMapCompletionStage(Function<? super T, ? extends CompletionStage<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMapCompletionStage(mapper));
    }

    public <S> PublisherBuilder<S> flatMapIterable(Function<? super T, ? extends Iterable<? extends S>> mapper) {
        return this.addStage((Stage)new Stages.FlatMapIterable(mapper));
    }

    public PublisherBuilder<T> limit(long maxSize) {
        return this.addStage((Stage)new Stages.Limit(maxSize));
    }

    public PublisherBuilder<T> skip(long n) {
        return this.addStage((Stage)new Stages.Skip(n));
    }

    public PublisherBuilder<T> takeWhile(Predicate<? super T> predicate) {
        return this.addStage((Stage)new Stages.TakeWhile(predicate));
    }

    public PublisherBuilder<T> dropWhile(Predicate<? super T> predicate) {
        return this.addStage((Stage)new Stages.DropWhile(predicate));
    }

    public CompletionRunner<Void> forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "Action must not be null");
        return this.collect(Collector.of(() -> null, (n, t) -> action.accept(t), (v1, v2) -> null, v -> null, new Collector.Characteristics[0]));
    }

    public CompletionRunner<Void> ignore() {
        return this.forEach((? super T r) -> {});
    }

    public CompletionRunner<Void> cancel() {
        return this.addTerminalStage((Stage)Stages.Cancel.INSTANCE);
    }

    public CompletionRunner<T> reduce(T identity, BinaryOperator<T> accumulator) {
        return this.addTerminalStage((Stage)new Stages.Collect(Reductions.reduce(identity, accumulator)));
    }

    public CompletionRunner<Optional<T>> reduce(BinaryOperator<T> accumulator) {
        return this.addTerminalStage((Stage)new Stages.Collect(Reductions.reduce(accumulator)));
    }

    public CompletionRunner<Optional<T>> findFirst() {
        return this.addTerminalStage((Stage)Stages.FindFirst.INSTANCE);
    }

    public <R, A> CompletionRunner<R> collect(Collector<? super T, A, R> collector) {
        return this.addTerminalStage((Stage)new Stages.Collect(collector));
    }

    public <R> CompletionRunner<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        return this.addTerminalStage((Stage)new Stages.Collect(Collector.of(supplier, accumulator, (a, b) -> a, new Collector.Characteristics[0])));
    }

    public CompletionRunner<List<T>> toList() {
        return this.collect(Collectors.toList());
    }

    public CompletionRunner<Void> to(Subscriber<? super T> subscriber) {
        return this.addTerminalStage((Stage)new Stages.SubscriberStage(subscriber));
    }

    public <R> CompletionRunner<R> to(SubscriberBuilder<? super T, ? extends R> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber must not be null");
        return this.addTerminalStage(InternalStages.nested(subscriber));
    }

    public <R> PublisherBuilder<R> via(ProcessorBuilder<? super T, ? extends R> processor) {
        return this.addStage(InternalStages.nested(processor));
    }

    public <R> PublisherBuilder<R> via(Processor<? super T, ? extends R> processor) {
        return this.addStage((Stage)new Stages.ProcessorStage(processor));
    }

    public PublisherBuilder<T> onError(Consumer<Throwable> errorHandler) {
        return this.addStage((Stage)new Stages.OnError(errorHandler));
    }

    public PublisherBuilder<T> onErrorResume(Function<Throwable, ? extends T> errorHandler) {
        return this.addStage((Stage)new Stages.OnErrorResume(errorHandler));
    }

    public PublisherBuilder<T> onErrorResumeWith(Function<Throwable, ? extends PublisherBuilder<? extends T>> errorHandler) {
        return this.addStage((Stage)new Stages.OnErrorResumeWith(errorHandler.andThen(ReactiveStreamsGraphBuilder::rsBuilderToGraph)));
    }

    public PublisherBuilder<T> onErrorResumeWithRsPublisher(Function<Throwable, ? extends Publisher<? extends T>> errorHandler) {
        return this.addStage((Stage)new Stages.OnErrorResumeWith(errorHandler.andThen(ReactiveStreamsGraphBuilder::publisherToGraph)));
    }

    public PublisherBuilder<T> onTerminate(Runnable action) {
        return this.addStage((Stage)new Stages.OnTerminate(action));
    }

    public PublisherBuilder<T> onComplete(Runnable action) {
        return this.addStage((Stage)new Stages.OnComplete(action));
    }

    public Publisher<T> buildRs() {
        return this.buildRs(ReactiveStreamsEngineResolver.instance());
    }

    public Publisher<T> buildRs(ReactiveStreamsEngine engine) {
        Objects.requireNonNull(engine, "Engine must not be null");
        return engine.buildPublisher(this.toGraph());
    }

    private <R> PublisherBuilder<R> addStage(Stage stage) {
        return new PublisherBuilderImpl<T>(stage, this);
    }

    private <R> CompletionRunner<R> addTerminalStage(Stage stage) {
        return new CompletionRunnerImpl(stage, this);
    }
}

