/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.opentelemetry.OpenTelemetryConfig;
import org.wildfly.extension.opentelemetry.OpenTelemetryHolder;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemDefinition;
import org.wildfly.extension.opentelemetry.deployment.OpenTelemetryDependencyProcessor;
import org.wildfly.extension.opentelemetry.deployment.OpenTelemetrySubsystemDeploymentProcessor;

public class OpenTelemetrySubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final OpenTelemetrySubsystemAdd INSTANCE = new OpenTelemetrySubsystemAdd();

    private OpenTelemetrySubsystemAdd() {
        super(OpenTelemetrySubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        OpenTelemetryConfig config = OpenTelemetryConfig.OpenTelemetryConfigBuilder.config().withServiceName(OpenTelemetrySubsystemDefinition.SERVICE_NAME.resolveModelAttribute(context, model).asStringOrNull()).withExporter(OpenTelemetrySubsystemDefinition.EXPORTER.resolveModelAttribute(context, model).asString()).withEndpoint(OpenTelemetrySubsystemDefinition.ENDPOINT.resolveModelAttribute(context, model).asStringOrNull()).withSpanProcessor(OpenTelemetrySubsystemDefinition.SPAN_PROCESSOR_TYPE.resolveModelAttribute(context, model).asString()).withBatchDelay(OpenTelemetrySubsystemDefinition.BATCH_DELAY.resolveModelAttribute(context, model).asLong()).withMaxQueueSize(OpenTelemetrySubsystemDefinition.MAX_QUEUE_SIZE.resolveModelAttribute(context, model).asInt()).withMaxExportBatchSize(OpenTelemetrySubsystemDefinition.MAX_EXPORT_BATCH_SIZE.resolveModelAttribute(context, model).asInt()).withExportTimeout(OpenTelemetrySubsystemDefinition.EXPORT_TIMEOUT.resolveModelAttribute(context, model).asLong()).withSampler(OpenTelemetrySubsystemDefinition.SAMPLER.resolveModelAttribute(context, model).asStringOrNull()).withRatio(OpenTelemetrySubsystemDefinition.RATIO.resolveModelAttribute(context, model).asDoubleOrNull()).build();
        final OpenTelemetryHolder holder = new OpenTelemetryHolder(config);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("opentelemetry", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new OpenTelemetryDependencyProcessor());
                processorTarget.addDeploymentProcessor("opentelemetry", Phase.POST_MODULE, 14352, (DeploymentUnitProcessor)new OpenTelemetrySubsystemDeploymentProcessor(holder));
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

