/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;

public abstract class ClientListenerOperation
extends RetryOnFailureOperation<SocketAddress> {
    public final byte[] listenerId;
    public final Object listener;
    protected final String cacheNameString;
    protected final ClientListenerNotifier listenerNotifier;
    protected SocketAddress address;

    protected ClientListenerOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] listenerId, DataFormat dataFormat, Object listener, String cacheNameString, ClientListenerNotifier listenerNotifier) {
        super(requestCode, responseCode, codec, channelFactory, cacheName, topologyId, flags, cfg, dataFormat);
        this.listenerId = listenerId;
        this.listener = listener;
        this.cacheNameString = cacheNameString;
        this.listenerNotifier = listenerNotifier;
    }

    protected static byte[] generateListenerId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] listenerId = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(listenerId);
        bb.putLong(random.nextLong());
        bb.putLong(random.nextLong());
        return listenerId;
    }

    protected ClientListener extractClientListener() {
        ClientListener l = (ClientListener)ReflectionUtil.getAnnotation(this.listener.getClass(), ClientListener.class);
        if (l == null) {
            throw Log.HOTROD.missingClientListenerAnnotation(this.listener.getClass().getName());
        }
        return l;
    }

    public String getCacheName() {
        return this.cacheNameString;
    }

    @Override
    protected final void executeOperation(Channel channel) {
        if (!channel.isActive()) {
            this.channelInactive(channel);
            return;
        }
        this.address = ChannelRecord.of(channel).getUnresolvedAddress();
        this.actualExecute(channel);
    }

    protected abstract void actualExecute(Channel var1);

    protected void cleanup(Channel channel) {
        channel.eventLoop().execute(() -> {
            HeaderDecoder decoder;
            if (!this.codec.allowOperationsAndEvents() && channel.isOpen()) {
                this.channelFactory.releaseChannel(channel);
            }
            if ((decoder = (HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)) != null) {
                decoder.removeListener(this.listenerId);
            }
        });
    }

    @Override
    public void releaseChannel(Channel channel) {
        if (this.codec.allowOperationsAndEvents()) {
            super.releaseChannel(channel);
        }
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (!HotRodConstants.isSuccess(status)) {
            this.listenerNotifier.removeClientListener(this.listenerId);
            throw Log.HOTROD.failedToAddListener(this.listener, status);
        }
        decoder.addListener(this.listenerId);
        this.listenerNotifier.startClientListener(this.listenerId);
        this.complete(this.address);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (!this.isDone()) {
            this.listenerNotifier.removeClientListener(this.listenerId);
        }
        return super.completeExceptionally(ex);
    }

    public void postponeTimeout(Channel channel) {
        assert (!this.isDone());
        this.timeoutFuture.cancel(false);
        this.timeoutFuture = null;
        this.scheduleTimeout(channel);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append("listenerId=").append(Util.printArray((byte[])this.listenerId));
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public abstract ClientListenerOperation copy();
}

