/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.ConfigValue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Experimental(value="Extension to the original ConfigSource to allow retrieval of additional metadata on config lookup")
public final class ConfigValueMapView
extends AbstractMap<String, String> {
    private final Map<String, ConfigValue> delegate;
    private transient Set<Map.Entry<String, String>> entrySet;
    private transient Collection<String> values;

    ConfigValueMapView(Map<String, ConfigValue> delegate) {
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public String get(Object key) {
        ConfigValue configValue = this.delegate.get(key);
        return configValue != null ? configValue.getValue() : null;
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    return new Iterator<Map.Entry<String, String>>(){
                        final Iterator<Map.Entry<String, ConfigValue>> delegate;
                        {
                            this.delegate = ConfigValueMapView.this.delegate.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegate.hasNext();
                        }

                        @Override
                        public Map.Entry<String, String> next() {
                            Map.Entry<String, ConfigValue> next = this.delegate.next();
                            ConfigValue configValue = next.getValue();
                            String value = configValue != null ? configValue.getValue() : null;
                            return new AbstractMap.SimpleImmutableEntry<String, String>(next.getKey(), value);
                        }
                    };
                }

                @Override
                public int size() {
                    return ConfigValueMapView.this.delegate.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public Collection<String> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<String>(){

                @Override
                public Iterator<String> iterator() {
                    final Iterator delegate = ConfigValueMapView.this.delegate.values().iterator();
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return delegate.hasNext();
                        }

                        @Override
                        public String next() {
                            ConfigValue configValue = (ConfigValue)delegate.next();
                            return configValue != null ? configValue.getValue() : null;
                        }
                    };
                }

                @Override
                public int size() {
                    return ConfigValueMapView.this.delegate.size();
                }
            };
        }
        return this.values;
    }
}

