/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.host.controller.jvm.JvmType;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.jvm.JvmElement;
import org.wildfly.common.Assert;

public final class JvmOptionsBuilderFactory {
    private static final List<String> MODULAR_JVM_PARAMS = Arrays.asList("--add-exports", "--add-opens", "--add-modules", "--add-reads", "--illegal-access");
    private final JvmType jvmType;

    private JvmOptionsBuilderFactory(JvmType jvmType) {
        this.jvmType = jvmType;
    }

    public static JvmOptionsBuilderFactory getInstance(JvmType jvmType) {
        return new JvmOptionsBuilderFactory(jvmType);
    }

    public void addOptions(JvmElement jvmElement, List<String> command) {
        List<String> options;
        Assert.checkNotNullParam((String)"jvmElement", (Object)jvmElement);
        Assert.checkNotNullParam((String)"command", command);
        String heap = jvmElement.getHeapSize();
        String maxHeap = jvmElement.getMaxHeap();
        if (maxHeap == null && heap != null) {
            maxHeap = heap;
        }
        if (heap == null && maxHeap != null) {
            heap = maxHeap;
        }
        if (heap != null) {
            command.add("-Xms" + heap);
        }
        if (maxHeap != null) {
            command.add("-Xmx" + maxHeap);
        }
        if (jvmElement.getStack() != null) {
            command.add("-Xss" + jvmElement.getStack());
        }
        if (jvmElement.getAgentPath() != null) {
            command.add("-agentpath:" + jvmElement.getAgentPath());
        }
        if (jvmElement.getAgentLib() != null) {
            command.add("-agentlib:" + jvmElement.getAgentLib());
        }
        if (jvmElement.getJavaagent() != null) {
            command.add("-javaagent:" + jvmElement.getJavaagent());
        }
        if (jvmElement.isDebugEnabled() != null && jvmElement.isDebugEnabled().booleanValue() && jvmElement.getDebugOptions() != null) {
            command.add(jvmElement.getDebugOptions());
        }
        if (!(options = jvmElement.getJvmOptions().getOptions()).isEmpty()) {
            String jvmName = jvmElement.getName();
            for (String option : options) {
                if (!this.checkOption(heap != null && option.startsWith("-Xms"), jvmName, option, Element.HEAP.toString()) || !this.checkOption(maxHeap != null && option.startsWith("-Xmx"), jvmName, option, Element.HEAP.toString()) || !this.checkOption(jvmElement.getStack() != null && option.startsWith("-Xss"), jvmName, option, Element.STACK.toString()) || !this.checkOption(jvmElement.isDebugEnabled() != null && jvmElement.isDebugEnabled() != false && jvmElement.getDebugOptions() != null && (option.startsWith("-Xrunjdwp") || option.startsWith("-agentlib:jdwp")), jvmName, option, Attribute.DEBUG_OPTIONS.toString()) || !this.checkOption(jvmElement.getAgentPath() != null && option.startsWith("-agentpath:"), jvmName, option, Element.AGENT_PATH.toString()) || !this.checkOption(jvmElement.getAgentLib() != null && option.startsWith("-agentlib:"), jvmName, option, Element.AGENT_LIB.toString()) || !this.checkOption(jvmElement.getAgentLib() != null && option.startsWith("-javaagent:"), jvmName, option, Element.AGENT_LIB.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-Xmx"), jvmName, option, Element.JAVA_AGENT.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-XX:PermSize"), jvmName, option, Element.PERMGEN.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-XX:MaxPermSize"), jvmName, option, Element.PERMGEN.toString()) || !this.checkAdditionalJvmOption(option)) continue;
                command.add(option);
            }
        }
    }

    boolean checkOption(boolean condition, String jvm, String option, String schemaElement) {
        if (condition) {
            HostControllerLogger.ROOT_LOGGER.optionAlreadySet(option, jvm, schemaElement);
            return false;
        }
        return true;
    }

    boolean checkAdditionalJvmOption(String option) {
        if (!this.jvmType.isForLaunch() || this.jvmType.isModularJvm()) {
            return true;
        }
        return !MODULAR_JVM_PARAMS.contains(option.contains("=") ? option.substring(0, option.indexOf("=")) : option);
    }
}

