/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public interface KafkaConsumer<K, V> {
    @CheckReturnValue
    public <R> Uni<R> runOnPollingThread(Function<Consumer<K, V>, R> var1);

    @CheckReturnValue
    public Uni<Void> runOnPollingThread(java.util.function.Consumer<Consumer<K, V>> var1);

    @CheckReturnValue
    public Uni<Set<TopicPartition>> pause();

    @CheckReturnValue
    public Uni<Set<TopicPartition>> paused();

    @CheckReturnValue
    public Uni<Map<TopicPartition, OffsetAndMetadata>> committed(TopicPartition ... var1);

    @CheckReturnValue
    public Uni<Void> resume();

    public Consumer<K, V> unwrap();

    @CheckReturnValue
    public Uni<Void> commit(Map<TopicPartition, OffsetAndMetadata> var1);

    @CheckReturnValue
    public Uni<Map<TopicPartition, Long>> getPositions();

    @CheckReturnValue
    public Uni<Set<TopicPartition>> getAssignments();

    @CheckReturnValue
    public Uni<Void> seek(TopicPartition var1, long var2);

    @CheckReturnValue
    public Uni<Void> seek(TopicPartition var1, OffsetAndMetadata var2);

    @CheckReturnValue
    public Uni<Void> seekToBeginning(Collection<TopicPartition> var1);

    @CheckReturnValue
    public Uni<Void> seekToEnd(Collection<TopicPartition> var1);
}

