/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.ListIterator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.as.server.services.net.BindingFixedPortHandler;
import org.jboss.as.server.services.net.BindingInterfaceHandler;
import org.jboss.as.server.services.net.BindingMulticastAddressHandler;
import org.jboss.as.server.services.net.BindingMulticastPortHandler;
import org.jboss.as.server.services.net.BindingPortHandler;
import org.jboss.as.server.services.net.BindingRemoveHandler;
import org.jboss.as.server.services.net.BindingRuntimeHandlers;
import org.jboss.as.server.services.net.ClientMappingsHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingResourceDefinition
extends AbstractSocketBindingResourceDefinition {
    public static final RuntimeCapability<Void> SOCKET_BINDING_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.network.socket-binding", (boolean)true, SocketBinding.class).build();
    public static final SocketBindingResourceDefinition INSTANCE = new SocketBindingResourceDefinition();

    private SocketBindingResourceDefinition() {
        super((OperationStepHandler)BindingAddHandler.INSTANCE, (OperationStepHandler)BindingRemoveHandler.INSTANCE, new RuntimeCapability[]{SOCKET_BINDING_CAPABILITY});
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(BindingRuntimeHandlers.BoundHandler.ATTRIBUTE_DEFINITION, BindingRuntimeHandlers.BoundHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(BindingRuntimeHandlers.BoundAddressHandler.ATTRIBUTE_DEFINITION, BindingRuntimeHandlers.BoundAddressHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(BindingRuntimeHandlers.BoundPortHandler.ATTRIBUTE_DEFINITION, BindingRuntimeHandlers.BoundPortHandler.INSTANCE);
    }

    protected OperationStepHandler getInterfaceWriteAttributeHandler() {
        return BindingInterfaceHandler.INSTANCE;
    }

    protected OperationStepHandler getPortWriteAttributeHandler() {
        return BindingPortHandler.INSTANCE;
    }

    protected OperationStepHandler getFixedPortWriteAttributeHandler() {
        return BindingFixedPortHandler.INSTANCE;
    }

    protected OperationStepHandler getMulticastAddressWriteAttributeHandler() {
        return BindingMulticastAddressHandler.INSTANCE;
    }

    protected OperationStepHandler getMulticastPortWriteAttributeHandler() {
        return BindingMulticastPortHandler.INSTANCE;
    }

    protected OperationStepHandler getClientMappingsWriteAttributeHandler() {
        return ClientMappingsHandler.INSTANCE;
    }

    static void validateInterfaceReference(OperationContext context, ModelNode binding) throws OperationFailedException {
        ModelNode interfaceNode = binding.get(INTERFACE.getName());
        if (interfaceNode.getType() == ModelType.STRING) {
            PathElement element;
            String interfaceName = interfaceNode.asString();
            PathAddress operationAddress = context.getCurrentAddress();
            PathAddress interfaceAddress = PathAddress.EMPTY_ADDRESS;
            ListIterator listIterator = operationAddress.iterator();
            while (listIterator.hasNext() && !(element = (PathElement)listIterator.next()).getKey().equals("socket-binding-group")) {
                interfaceAddress = interfaceAddress.append(new PathElement[]{element});
            }
            interfaceAddress = interfaceAddress.append("interface", interfaceName);
            try {
                context.readResourceFromRoot(interfaceAddress, false);
            }
            catch (RuntimeException e) {
                throw ControllerLogger.ROOT_LOGGER.nonexistentInterface(interfaceName, INTERFACE.getName());
            }
        }
    }
}

