/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.wildfly.security.tool.ElytronToolMessages;

public abstract class Command {
    public static int GENERAL_CONFIGURATION_ERROR = 7;
    public static int INPUT_DATA_NOT_CONFIRMED = 3;
    private int status = 255;
    private List<String> redirectionValues;
    private boolean enableDebug;
    private String toolCommand = "java -jar wildfly-elytron-tool.jar";
    public static int WIDTH = 1024;

    public abstract void execute(String[] var1) throws Exception;

    public void help() {
    }

    public boolean isAlias(String alias) {
        return this.aliases().contains(alias);
    }

    protected Set<String> aliases() {
        return Collections.emptySet();
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public static boolean isWindows() {
        String opsys = System.getProperty("os.name").toLowerCase();
        return opsys.indexOf("win") >= 0;
    }

    protected String prompt(boolean echo, String prompt, boolean confirm, String confirmPrompt) throws Exception {
        Console console = System.console();
        if (echo || console == null) {
            String first;
            if (console == null && this.redirectionValues == null) {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));){
                    String value;
                    this.redirectionValues = new ArrayList<String>();
                    while ((value = in.readLine()) != null) {
                        this.redirectionValues.add(value);
                    }
                }
                catch (IOException e) {
                    this.setStatus(GENERAL_CONFIGURATION_ERROR);
                    throw new Exception(e);
                }
            }
            String string = console != null ? console.readLine(prompt, new Object[0]) : (first = this.redirectionValues.size() == 0 ? null : this.redirectionValues.remove(0));
            if (first != null && confirm) {
                String second;
                String string2 = console != null ? console.readLine(confirmPrompt, new Object[0]) : (second = this.redirectionValues.size() == 0 ? null : this.redirectionValues.remove(0));
                if (first.equals(second)) {
                    return first;
                }
                System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
                System.exit(INPUT_DATA_NOT_CONFIRMED);
                return null;
            }
            return first;
        }
        char[] inVisible = console.readPassword(prompt != null ? prompt : "Password:", new Object[0]);
        if (inVisible != null && confirm) {
            char[] inVisible2 = console.readPassword(confirmPrompt != null ? confirmPrompt : "Confirm password:", new Object[0]);
            if (Arrays.equals(inVisible, inVisible2)) {
                return new String(inVisible);
            }
            System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
            System.exit(INPUT_DATA_NOT_CONFIRMED);
            return null;
        }
        if (inVisible != null) {
            return new String(inVisible);
        }
        return null;
    }

    public void printDuplicatesWarning(CommandLine cmdLine) {
        ArrayList<Option> optionsList = new ArrayList<Option>(Arrays.asList(cmdLine.getOptions()));
        HashSet<Option> duplicatesSet = new HashSet<Option>();
        for (Option option : cmdLine.getOptions()) {
            if (Collections.frequency(optionsList, option) <= 1) continue;
            duplicatesSet.add(option);
        }
        for (Option option : duplicatesSet) {
            System.out.println(ElytronToolMessages.msg.duplicateOptionSpecified(option.getLongOpt()));
        }
    }

    public void printDuplicatesWarning(CommandLine cmdLine, List<String> duplicatesAllowed) {
        if (duplicatesAllowed == null) {
            return;
        }
        ArrayList<Option> optionsList = new ArrayList<Option>(Arrays.asList(cmdLine.getOptions()));
        HashSet<Option> duplicatesSet = new HashSet<Option>();
        for (Option option : cmdLine.getOptions()) {
            if (Collections.frequency(optionsList, option) <= 1 || duplicatesAllowed.contains(option.getLongOpt())) continue;
            duplicatesSet.add(option);
        }
        for (Option option : duplicatesSet) {
            System.out.println(ElytronToolMessages.msg.duplicateOptionSpecified(option.getLongOpt()));
        }
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public String getToolCommand() {
        return this.toolCommand;
    }

    public void setToolCommand(String toolCommand) {
        this.toolCommand = toolCommand;
    }

    protected Supplier<Provider[]> getProvidersSupplier(String providersList) {
        return () -> {
            if (providersList != null && !providersList.isEmpty()) {
                String[] providerNames = providersList.split(",");
                ArrayList<Provider> providers = new ArrayList<Provider>(providerNames.length);
                for (String p : providerNames) {
                    Provider provider = Security.getProvider(p.trim());
                    if (provider == null) continue;
                    providers.add(provider);
                }
                ServiceLoader<Provider> providerLoader = ServiceLoader.load(Provider.class);
                block1: for (Provider provider : providerLoader) {
                    for (String p : providerNames) {
                        if (!provider.getName().equals(p)) continue;
                        providers.add(provider);
                        continue block1;
                    }
                }
                if (providers.isEmpty()) {
                    throw ElytronToolMessages.msg.unknownProvider(providersList);
                }
                return providers.toArray(new Provider[providers.size()]);
            }
            ServiceLoader<Provider> providerLoader = ServiceLoader.load(Provider.class);
            Iterator<Provider> providerIterator = providerLoader.iterator();
            ArrayList<Provider> providers = new ArrayList<Provider>();
            while (providerIterator.hasNext()) {
                Provider provider = providerIterator.next();
                if (provider.getName().equals("WildFlyElytron")) continue;
                providers.add(provider);
            }
            return providers.toArray(new Provider[providers.size()]);
        };
    }
}

