/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.util.Util;

public class AnycastAddress
implements Address,
Constructable<AnycastAddress> {
    protected Collection<Address> destinations;

    public AnycastAddress() {
    }

    public AnycastAddress(Collection<Address> addresses) {
        this.addAll(addresses);
    }

    public AnycastAddress(Address ... addresses) {
        this.add(addresses);
    }

    @Override
    public Supplier<? extends AnycastAddress> create() {
        return AnycastAddress::new;
    }

    public void add(Address ... addresses) {
        if (addresses.length == 0) {
            return;
        }
        this.initCollection(addresses.length);
        for (Address address : addresses) {
            this.internalAdd(address);
        }
    }

    protected void internalAdd(Address address) {
        if (!this.destinations.contains(address)) {
            this.destinations.add(address);
        }
    }

    public void addAll(Collection<Address> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return;
        }
        this.initCollection(addresses.size());
        addresses.forEach(this::internalAdd);
    }

    public Collection<Address> getAddresses() {
        return this.destinations;
    }

    public Optional<Collection<Address>> findAddresses() {
        return Optional.ofNullable(this.destinations);
    }

    private void initCollection(int estimatedSize) {
        if (this.destinations == null) {
            this.destinations = new ArrayList<Address>(estimatedSize);
        }
    }

    @Override
    public int serializedSize() {
        if (this.destinations == null) {
            return 4;
        }
        int size = 4;
        for (Address address : this.destinations) {
            size += Util.size(address);
        }
        return size;
    }

    public String toString() {
        return "AnycastAddress " + this.destinations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnycastAddress that = (AnycastAddress)o;
        return Objects.equals(this.destinations, that.destinations);
    }

    public int hashCode() {
        return this.destinations != null ? this.destinations.hashCode() : 0;
    }

    @Override
    public int compareTo(Address o) {
        int hc2;
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AnycastAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + (o != null ? o.getClass() : o));
        }
        AnycastAddress other = (AnycastAddress)o;
        int hc1 = this.hashCode();
        if (hc1 == (hc2 = other.hashCode())) {
            int size = this.destinations == null ? 0 : this.destinations.size();
            int otherSize = other.destinations == null ? 0 : other.destinations.size();
            return size - otherSize;
        }
        return hc1 < hc2 ? -1 : 1;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Util.writeAddresses(this.destinations, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.destinations = Util.readAddresses(in, ArrayList::new);
    }
}

