/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;

public class ActiveMQRAMCFProperties
extends ConnectionFactoryProperties
implements Serializable {
    static final long serialVersionUID = -5951352236582886862L;
    private static final String QUEUE_TYPE = Queue.class.getName();
    private static final String TOPIC_TYPE = Topic.class.getName();
    private boolean allowLocalTransactions;
    private boolean inJtaTransaction;
    private String strConnectorClassName;
    public String strConnectionParameters;
    private int type = 0;
    private Integer useTryLock;

    public ActiveMQRAMCFProperties() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
        this.useTryLock = null;
    }

    public int getType() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getType()");
        }
        return this.type;
    }

    public String getConnectorClassName() {
        return this.strConnectorClassName;
    }

    public void setConnectorClassName(String connectorClassName) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setConnectorClassName(" + connectorClassName + ")");
        }
        this.strConnectorClassName = connectorClassName;
        this.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getStrConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(configuration));
    }

    public void setSessionDefaultType(String defaultType) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setSessionDefaultType(" + this.type + ")");
        }
        this.type = defaultType.equals(QUEUE_TYPE) ? 1 : (defaultType.equals(TOPIC_TYPE) ? 2 : 0);
    }

    public String getSessionDefaultType() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getSessionDefaultType()");
        }
        if (this.type == 0) {
            return "BOTH";
        }
        if (this.type == 1) {
            return TOPIC_TYPE;
        }
        return QUEUE_TYPE;
    }

    public Integer getUseTryLock() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getUseTryLock()");
        }
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setUseTryLock(" + useTryLock + ")");
        }
        this.useTryLock = useTryLock;
    }

    public boolean isAllowLocalTransactions() {
        return this.allowLocalTransactions;
    }

    public void setAllowLocalTransactions(boolean allowLocalTransactions) {
        this.allowLocalTransactions = allowLocalTransactions;
    }

    public boolean isInJtaTransaction() {
        return this.inJtaTransaction;
    }

    public void setInJtaTransaction(boolean inJtaTransaction) {
        this.inJtaTransaction = inJtaTransaction;
    }
}

