/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.internal.CodedOutputStream;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;

public final class StringAnyValueMarshaler
extends MarshalerWithSize {
    private final byte[] valueUtf8;

    public StringAnyValueMarshaler(byte[] valueUtf8) {
        super(StringAnyValueMarshaler.calculateSize(valueUtf8));
        this.valueUtf8 = valueUtf8;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeString(AnyValue.STRING_VALUE, this.valueUtf8);
    }

    private static int calculateSize(byte[] valueUtf8) {
        return AnyValue.STRING_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(valueUtf8);
    }
}

