/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.as.clustering.jgroups.subsystem.AuthProtocolResourceTransformer;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceTransformer;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;

public class ProtocolTransformer
implements Consumer<ModelVersion> {
    private final Map<ProtocolRegistration.AuthProtocol, ResourceTransformationDescriptionBuilder> authBuilders = new EnumMap<ProtocolRegistration.AuthProtocol, ResourceTransformationDescriptionBuilder>(ProtocolRegistration.AuthProtocol.class);
    private final Map<ProtocolRegistration.EncryptProtocol, ResourceTransformationDescriptionBuilder> encryptBuilders = new EnumMap<ProtocolRegistration.EncryptProtocol, ResourceTransformationDescriptionBuilder>(ProtocolRegistration.EncryptProtocol.class);

    ProtocolTransformer(ResourceTransformationDescriptionBuilder parent) {
        for (ProtocolRegistration.AuthProtocol authProtocol : EnumSet.allOf(ProtocolRegistration.AuthProtocol.class)) {
            this.authBuilders.put(authProtocol, parent.addChildResource(ProtocolResourceDefinition.pathElement(authProtocol.name())));
        }
        for (ProtocolRegistration.EncryptProtocol encryptProtocol : EnumSet.allOf(ProtocolRegistration.EncryptProtocol.class)) {
            this.encryptBuilders.put(encryptProtocol, parent.addChildResource(ProtocolResourceDefinition.pathElement(encryptProtocol.name())));
        }
    }

    @Override
    public void accept(ModelVersion version) {
        for (ResourceTransformationDescriptionBuilder builder : this.authBuilders.values()) {
            new AuthProtocolResourceTransformer(builder).accept(version);
        }
        for (ResourceTransformationDescriptionBuilder builder : this.encryptBuilders.values()) {
            new EncryptProtocolResourceTransformer(builder).accept(version);
        }
    }
}

