/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.query.dsl.SimpleQueryStringTermination;
import org.hibernate.search.query.dsl.impl.ConnectedSimpleQueryParser;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RemoteSimpleQueryStringQuery;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedMultiFieldsSimpleQueryStringQueryBuilder
implements SimpleQueryStringTermination {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final String simpleQueryString;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldsContext> fieldsContexts;
    private final QueryBuildingContext queryContext;
    private final boolean withAndAsDefaultOperator;

    public ConnectedMultiFieldsSimpleQueryStringQueryBuilder(String simpleQueryString, List<FieldsContext> fieldsContexts, boolean withAndAsDefaultOperator, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.simpleQueryString = simpleQueryString;
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContexts = fieldsContexts;
        this.withAndAsDefaultOperator = withAndAsDefaultOperator;
    }

    @Override
    public Query createQuery() {
        Query query;
        if (this.simpleQueryString == null) {
            throw LOG.simpleQueryParserDoesNotSupportNullQueries();
        }
        if (this.queryContext.getQueryAnalyzerReference().is(RemoteAnalyzerReference.class)) {
            RemoteSimpleQueryStringQuery.Builder builder = new RemoteSimpleQueryStringQuery.Builder().query(this.simpleQueryString).withAndAsDefaultOperator(this.withAndAsDefaultOperator).originalRemoteAnalyzerReference(this.queryContext.getOriginalAnalyzerReference().unwrap(RemoteAnalyzerReference.class)).queryRemoteAnalyzerReference(this.queryContext.getQueryAnalyzerReference().unwrap(RemoteAnalyzerReference.class));
            this.fieldsContexts.forEach(fieldsContext -> fieldsContext.forEach(fieldContext -> builder.field(fieldContext.getField(), fieldContext.getFieldCustomizer().getBoost())));
            query = builder.build();
        } else {
            ConnectedSimpleQueryParser queryParser = new ConnectedSimpleQueryParser(this.queryContext.getQueryAnalyzerReference().unwrap(LuceneAnalyzerReference.class).getAnalyzer(), this.fieldsContexts);
            queryParser.setDefaultOperator(this.withAndAsDefaultOperator ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            query = queryParser.parse(this.simpleQueryString);
        }
        return this.queryCustomizer.setWrappedQuery(query).createQuery();
    }
}

