/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.legacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class LegacyConnectionFactoryService
implements Service<ConnectionFactory> {
    private static final Map<String, String> PARAM_KEY_MAPPING = new HashMap<String, String>();
    private final InjectedValue<ActiveMQServer> injectedActiveMQServer = new InjectedValue();
    private final HornetQConnectionFactory uncompletedConnectionFactory;
    private final String discoveryGroupName;
    private final List<String> connectors;
    private HornetQConnectionFactory connectionFactory;

    public LegacyConnectionFactoryService(HornetQConnectionFactory uncompletedConnectionFactory, String discoveryGroupName, List<String> connectors) {
        this.uncompletedConnectionFactory = uncompletedConnectionFactory;
        this.discoveryGroupName = discoveryGroupName;
        this.connectors = connectors;
    }

    public void start(StartContext context) throws StartException {
        ActiveMQServer activeMQServer = (ActiveMQServer)this.injectedActiveMQServer.getValue();
        org.hornetq.api.core.DiscoveryGroupConfiguration discoveryGroupConfiguration = null;
        if (this.discoveryGroupName != null) {
            if (activeMQServer.getConfiguration().getDiscoveryGroupConfigurations().keySet().contains(this.discoveryGroupName)) {
                discoveryGroupConfiguration = this.translateDiscoveryGroupConfiguration((DiscoveryGroupConfiguration)activeMQServer.getConfiguration().getDiscoveryGroupConfigurations().get(this.discoveryGroupName));
            } else {
                throw MessagingLogger.ROOT_LOGGER.discoveryGroupIsNotDefined(this.discoveryGroupName);
            }
        }
        org.hornetq.api.core.TransportConfiguration[] transportConfigurations = this.translateTransportGroupConfigurations(activeMQServer.getConfiguration().getConnectorConfigurations(), this.connectors);
        JMSFactoryType factoryType = JMSFactoryType.valueOf((int)this.uncompletedConnectionFactory.getFactoryType());
        this.connectionFactory = this.uncompletedConnectionFactory.isHA() ? (discoveryGroupConfiguration != null ? HornetQJMSClient.createConnectionFactoryWithHA((org.hornetq.api.core.DiscoveryGroupConfiguration)discoveryGroupConfiguration, (JMSFactoryType)factoryType) : HornetQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)factoryType, (org.hornetq.api.core.TransportConfiguration[])transportConfigurations)) : (discoveryGroupConfiguration != null ? HornetQJMSClient.createConnectionFactoryWithoutHA((org.hornetq.api.core.DiscoveryGroupConfiguration)discoveryGroupConfiguration, (JMSFactoryType)factoryType) : HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)factoryType, (org.hornetq.api.core.TransportConfiguration[])transportConfigurations));
        this.connectionFactory.setAutoGroup(this.uncompletedConnectionFactory.isAutoGroup());
        this.connectionFactory.setBlockOnAcknowledge(this.uncompletedConnectionFactory.isBlockOnAcknowledge());
        this.connectionFactory.setBlockOnDurableSend(this.uncompletedConnectionFactory.isBlockOnDurableSend());
        this.connectionFactory.setBlockOnNonDurableSend(this.uncompletedConnectionFactory.isBlockOnNonDurableSend());
        this.connectionFactory.setCacheLargeMessagesClient(this.uncompletedConnectionFactory.isCacheLargeMessagesClient());
        this.connectionFactory.setCallFailoverTimeout(this.uncompletedConnectionFactory.getCallFailoverTimeout());
        this.connectionFactory.setCallTimeout(this.uncompletedConnectionFactory.getCallTimeout());
        this.connectionFactory.setClientFailureCheckPeriod(this.uncompletedConnectionFactory.getClientFailureCheckPeriod());
        this.connectionFactory.setClientID(this.uncompletedConnectionFactory.getClientID());
        this.connectionFactory.setCompressLargeMessage(this.uncompletedConnectionFactory.isCompressLargeMessage());
        this.connectionFactory.setConfirmationWindowSize(this.uncompletedConnectionFactory.getConfirmationWindowSize());
        this.connectionFactory.setConnectionLoadBalancingPolicyClassName(this.uncompletedConnectionFactory.getConnectionLoadBalancingPolicyClassName());
        this.connectionFactory.setConnectionTTL(this.uncompletedConnectionFactory.getConnectionTTL());
        this.connectionFactory.setConsumerMaxRate(this.uncompletedConnectionFactory.getConsumerMaxRate());
        this.connectionFactory.setConsumerWindowSize(this.uncompletedConnectionFactory.getConsumerWindowSize());
        this.connectionFactory.setConfirmationWindowSize(this.uncompletedConnectionFactory.getConfirmationWindowSize());
        this.connectionFactory.setDupsOKBatchSize(this.uncompletedConnectionFactory.getDupsOKBatchSize());
        this.connectionFactory.setFailoverOnInitialConnection(this.uncompletedConnectionFactory.isFailoverOnInitialConnection());
        this.connectionFactory.setGroupID(this.uncompletedConnectionFactory.getGroupID());
        this.connectionFactory.setInitialConnectAttempts(this.uncompletedConnectionFactory.getInitialConnectAttempts());
        this.connectionFactory.setInitialMessagePacketSize(this.uncompletedConnectionFactory.getInitialMessagePacketSize());
        this.connectionFactory.setMaxRetryInterval(this.uncompletedConnectionFactory.getMaxRetryInterval());
        this.connectionFactory.setMinLargeMessageSize(this.uncompletedConnectionFactory.getMinLargeMessageSize());
        this.connectionFactory.setPreAcknowledge(this.uncompletedConnectionFactory.isPreAcknowledge());
        this.connectionFactory.setProducerMaxRate(this.uncompletedConnectionFactory.getProducerMaxRate());
        this.connectionFactory.setProducerWindowSize(this.uncompletedConnectionFactory.getProducerWindowSize());
        this.connectionFactory.setReconnectAttempts(this.uncompletedConnectionFactory.getReconnectAttempts());
        this.connectionFactory.setRetryInterval(this.uncompletedConnectionFactory.getRetryInterval());
        this.connectionFactory.setRetryIntervalMultiplier(this.uncompletedConnectionFactory.getRetryIntervalMultiplier());
        this.connectionFactory.setScheduledThreadPoolMaxSize(this.uncompletedConnectionFactory.getScheduledThreadPoolMaxSize());
        this.connectionFactory.setThreadPoolMaxSize(this.uncompletedConnectionFactory.getThreadPoolMaxSize());
        this.connectionFactory.setTransactionBatchSize(this.uncompletedConnectionFactory.getTransactionBatchSize());
        this.connectionFactory.setUseGlobalPools(this.uncompletedConnectionFactory.isUseGlobalPools());
    }

    public void stop(StopContext context) {
        this.connectionFactory = null;
    }

    public ConnectionFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.connectionFactory;
    }

    public static LegacyConnectionFactoryService installService(String name, ServiceName activeMQServerServiceName, ServiceTarget serviceTarget, HornetQConnectionFactory uncompletedConnectionFactory, String discoveryGroupName, List<String> connectors) {
        LegacyConnectionFactoryService service = new LegacyConnectionFactoryService(uncompletedConnectionFactory, discoveryGroupName, connectors);
        ServiceName serviceName = JMSServices.getConnectionFactoryBaseServiceName(activeMQServerServiceName).append(new String[]{"legacy", name});
        ServiceBuilder sb = serviceTarget.addService(serviceName, (Service)service);
        sb.requires(ActiveMQActivationService.getServiceName(activeMQServerServiceName));
        sb.addDependency(activeMQServerServiceName, ActiveMQServer.class, service.injectedActiveMQServer);
        sb.setInitialMode(ServiceController.Mode.PASSIVE);
        sb.install();
        return service;
    }

    private org.hornetq.api.core.DiscoveryGroupConfiguration translateDiscoveryGroupConfiguration(DiscoveryGroupConfiguration newDiscoveryGroupConfiguration) throws StartException {
        JGroupsBroadcastGroupConfiguration legacyBroadcastEndpointFactory;
        BroadcastEndpointFactory newBroadcastEndpointFactory = newDiscoveryGroupConfiguration.getBroadcastEndpointFactory();
        if (newBroadcastEndpointFactory instanceof UDPBroadcastEndpointFactory) {
            UDPBroadcastEndpointFactory factory = (UDPBroadcastEndpointFactory)newBroadcastEndpointFactory;
            legacyBroadcastEndpointFactory = new UDPBroadcastGroupConfiguration(factory.getGroupAddress(), factory.getGroupPort(), factory.getLocalBindAddress(), factory.getLocalBindPort());
        } else if (newBroadcastEndpointFactory instanceof ChannelBroadcastEndpointFactory) {
            ChannelBroadcastEndpointFactory factory = (ChannelBroadcastEndpointFactory)newBroadcastEndpointFactory;
            legacyBroadcastEndpointFactory = new JGroupsBroadcastGroupConfiguration(factory.getChannel(), factory.getChannelName());
        } else {
            throw MessagingLogger.ROOT_LOGGER.unsupportedBroadcastGroupConfigurationForLegacy(newBroadcastEndpointFactory.getClass().getName());
        }
        return new org.hornetq.api.core.DiscoveryGroupConfiguration(newDiscoveryGroupConfiguration.getName(), newDiscoveryGroupConfiguration.getRefreshTimeout(), newDiscoveryGroupConfiguration.getDiscoveryInitialWaitTimeout(), (BroadcastEndpointFactoryConfiguration)legacyBroadcastEndpointFactory);
    }

    private org.hornetq.api.core.TransportConfiguration[] translateTransportGroupConfigurations(Map<String, TransportConfiguration> connectorConfigurations, List<String> connectors) throws StartException {
        ArrayList<org.hornetq.api.core.TransportConfiguration> legacyConnectorConfigurations = new ArrayList<org.hornetq.api.core.TransportConfiguration>();
        for (String connectorName : connectors) {
            TransportConfiguration newTransportConfiguration = connectorConfigurations.get(connectorName);
            String legacyFactoryClassName = this.translateFactoryClassName(newTransportConfiguration.getFactoryClassName());
            Map legacyParams = this.translateParams(newTransportConfiguration.getParams());
            org.hornetq.api.core.TransportConfiguration legacyTransportConfiguration = new org.hornetq.api.core.TransportConfiguration(legacyFactoryClassName, legacyParams, newTransportConfiguration.getName());
            legacyConnectorConfigurations.add(legacyTransportConfiguration);
        }
        return legacyConnectorConfigurations.toArray(new org.hornetq.api.core.TransportConfiguration[legacyConnectorConfigurations.size()]);
    }

    private String translateFactoryClassName(String newFactoryClassName) throws StartException {
        if (newFactoryClassName.equals(org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory.class.getName())) {
            return NettyConnectorFactory.class.getName();
        }
        throw MessagingLogger.ROOT_LOGGER.unsupportedConnectorFactoryForLegacy(newFactoryClassName.getClass().getName());
    }

    private Map translateParams(Map<String, Object> newParams) {
        HashMap<String, Object> legacyParams = new HashMap<String, Object>();
        for (Map.Entry<String, Object> newEntry : newParams.entrySet()) {
            String newKey = newEntry.getKey();
            Object value = newEntry.getValue();
            String legacyKey = PARAM_KEY_MAPPING.getOrDefault(newKey, newKey);
            if ("activemqServerName".equals(legacyKey)) continue;
            legacyParams.put(legacyKey, value);
        }
        return legacyParams;
    }

    static {
        PARAM_KEY_MAPPING.put("sslEnabled", "ssl-enabled");
        PARAM_KEY_MAPPING.put("httpEnabled", "http-enabled");
        PARAM_KEY_MAPPING.put("httpClientIdleTime", "http-client-idle-time");
        PARAM_KEY_MAPPING.put("httpClientIdleScanPeriod", "http-client-idle-scan-period");
        PARAM_KEY_MAPPING.put("httpRequiresSessionId", "http-requires-session-id");
        PARAM_KEY_MAPPING.put("httpUpgradeEnabled", "http-upgrade-enabled");
        PARAM_KEY_MAPPING.put("httpUpgradeEndpoint", "http-upgrade-endpoint");
        PARAM_KEY_MAPPING.put("useServlet", "use-servlet");
        PARAM_KEY_MAPPING.put("servletPath", "servlet-path");
        PARAM_KEY_MAPPING.put("useNio", "use-nio");
        PARAM_KEY_MAPPING.put("useNioGlobalWorkerPool", "use-nio-global-worker-pool");
        PARAM_KEY_MAPPING.put("localAddress", "local-address");
        PARAM_KEY_MAPPING.put("keyStoreProvider", "key-store-provider");
        PARAM_KEY_MAPPING.put("keyStorePath", "key-store-path");
        PARAM_KEY_MAPPING.put("keyStorePassword", "key-store-password");
        PARAM_KEY_MAPPING.put("trustStoreProvider", "trust-store-provider");
        PARAM_KEY_MAPPING.put("trustStorePath", "trust-store-path");
        PARAM_KEY_MAPPING.put("trustStorePassword", "trust-store-password");
        PARAM_KEY_MAPPING.put("enabledCipherSuites", "enabled-cipher-suites");
        PARAM_KEY_MAPPING.put("enabledProtocols", "enabled-protocols");
        PARAM_KEY_MAPPING.put("tcpNoDelay", "tcp-no-delay");
        PARAM_KEY_MAPPING.put("tcpSendBufferSize", "tcp-send-buffer-size");
        PARAM_KEY_MAPPING.put("tcpReceiveBufferSize", "tcp-receive-buffer-size");
        PARAM_KEY_MAPPING.put("nioRemotingThreads", "nio-remoting-threads");
        PARAM_KEY_MAPPING.put("batchDelay", "batch-delay");
        PARAM_KEY_MAPPING.put("nioRemotingThreads", "nio-remoting-threads");
        PARAM_KEY_MAPPING.put(ActiveMQDefaultConfiguration.getPropMaskPassword(), HornetQDefaultConfiguration.getPropMaskPassword());
        PARAM_KEY_MAPPING.put(ActiveMQDefaultConfiguration.getPropPasswordCodec(), HornetQDefaultConfiguration.getPropPasswordCodec());
        PARAM_KEY_MAPPING.put("connect-timeout-millis", "connect-timeout-millis");
    }
}

