/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.impl.table;

import java.util.List;
import java.util.function.Function;
import org.infinispan.persistence.jdbc.common.SqlManager;

public class GenericSqlManager
implements SqlManager {
    protected final String tableName;
    protected final boolean namedParameters;

    public GenericSqlManager(String tableName, boolean namedParameters) {
        this.tableName = tableName;
        this.namedParameters = namedParameters;
    }

    String parameterName(String columnName) {
        return this.namedParameters ? ":" + columnName : "?";
    }

    @Override
    public String getSelectStatement(List<String> keyColumns, List<String> allColumns) {
        StringBuilder select = new StringBuilder("SELECT ");
        this.appendStrings(select, allColumns, Function.identity(), ", ");
        select.append(" FROM ").append(this.tableName);
        select.append(" WHERE ");
        this.appendStrings(select, keyColumns, key -> key + " = " + this.parameterName((String)key), " AND ");
        return select.toString();
    }

    @Override
    public String getSelectAllStatement(List<String> allColumns) {
        StringBuilder selectAll = new StringBuilder("SELECT ");
        this.appendStrings(selectAll, allColumns, Function.identity(), ", ");
        selectAll.append(" FROM ").append(this.tableName);
        return selectAll.toString();
    }

    @Override
    public String getDeleteStatement(List<String> keyColumns) {
        StringBuilder delete = new StringBuilder("DELETE FROM ");
        delete.append(this.tableName);
        delete.append(" WHERE ");
        this.appendStrings(delete, keyColumns, key -> key + " = " + this.parameterName((String)key), " AND ");
        return delete.toString();
    }

    @Override
    public String getDeleteAllStatement() {
        return "DELETE FROM " + this.tableName;
    }

    protected Iterable<String> valueIterable(List<String> keyColumns, List<String> allColumns) {
        return () -> allColumns.stream().filter(all -> !keyColumns.contains(all)).iterator();
    }

    protected void appendStrings(StringBuilder sb, Iterable<String> strings, Function<String, String> valueConversion, String separator) {
        boolean isFirst = true;
        for (String columnName : strings) {
            if (!isFirst) {
                sb.append(separator);
            }
            sb.append(valueConversion.apply(columnName));
            isFirst = false;
        }
    }

    @Override
    public String getUpsertStatement(List<String> keyColumns, List<String> allColumns) {
        StringBuilder upsert = new StringBuilder("MERGE INTO ").append(this.tableName);
        upsert.append(" USING (VALUES (");
        this.appendStrings(upsert, allColumns, this::parameterName, ", ");
        upsert.append(")) AS tmp (");
        this.appendStrings(upsert, allColumns, Function.identity(), ", ");
        upsert.append(") ON (");
        this.appendStrings(upsert, keyColumns, key -> key + " = tmp." + key, ", ");
        upsert.append(") WHEN MATCHED THEN UPDATE SET ");
        this.appendStrings(upsert, this.valueIterable(keyColumns, allColumns), value -> value + " = tmp." + value, ", ");
        upsert.append(" WHEN NOT MATCHED THEN INSERT (");
        this.appendStrings(upsert, allColumns, Function.identity(), ", ");
        upsert.append(") VALUES (");
        this.appendStrings(upsert, allColumns, all -> "tmp." + all, ", ");
        upsert.append(')');
        return upsert.toString();
    }

    @Override
    public String getSizeCommand() {
        return "SELECT COUNT(*) FROM " + this.tableName;
    }
}

