/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ClassLoaderContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "CLASSLOADER";
    private final ClassLoader classLoader;

    public ClassLoaderContextHandleFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public SetupContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new ClassLoaderSetupContextHandle(this.classLoader);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 100;
    }

    @Override
    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new ClassLoaderSetupContextHandle(this.classLoader);
    }

    private static class ClassLoaderResetContextHandle
    implements ResetContextHandle {
        private static final long serialVersionUID = -579159484365527468L;
        private final ClassLoader previous;

        private ClassLoaderResetContextHandle(ClassLoader previous) {
            this.previous = previous;
        }

        @Override
        public void reset() {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.previous);
        }

        @Override
        public String getFactoryName() {
            return ClassLoaderContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }

    static class ClassLoaderSetupContextHandle
    implements SetupContextHandle {
        private static final long serialVersionUID = -2669625643479981561L;
        private final ClassLoader classLoader;

        ClassLoaderSetupContextHandle(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public ResetContextHandle setup() throws IllegalStateException {
            ClassLoaderResetContextHandle resetContextHandle = new ClassLoaderResetContextHandle(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            return resetContextHandle;
        }

        @Override
        public String getFactoryName() {
            return ClassLoaderContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }
}

