/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ConfigurationCleaner;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaProducer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class KafkaDeadLetterQueue
implements KafkaFailureHandler {
    public static final String DEAD_LETTER_REASON = "dead-letter-reason";
    public static final String DEAD_LETTER_CAUSE = "dead-letter-cause";
    public static final String DEAD_LETTER_TOPIC = "dead-letter-topic";
    public static final String DEAD_LETTER_OFFSET = "dead-letter-offset";
    public static final String DEAD_LETTER_PARTITION = "dead-letter-partition";
    private final String channel;
    private final ReactiveKafkaProducer producer;
    private final String topic;
    private final KafkaSource<?, ?> source;

    public KafkaDeadLetterQueue(String channel, String topic, ReactiveKafkaProducer producer, KafkaSource<?, ?> source) {
        this.channel = channel;
        this.topic = topic;
        this.producer = producer;
        this.source = source;
    }

    public static KafkaFailureHandler create(Map<String, ?> kafkaConfiguration, KafkaConnectorIncomingConfiguration conf, KafkaSource<?, ?> source, KafkaCDIEvents kafkaCDIEvents) {
        HashMap<String, Object> deadQueueProducerConfig = new HashMap<String, Object>();
        kafkaConfiguration.forEach((key, value) -> deadQueueProducerConfig.put((String)key, (String)value));
        String keyDeserializer = (String)deadQueueProducerConfig.remove("key.deserializer");
        String valueDeserializer = (String)deadQueueProducerConfig.remove("value.deserializer");
        deadQueueProducerConfig.remove("interceptor.classes");
        deadQueueProducerConfig.put("key.serializer", conf.getDeadLetterQueueKeySerializer().orElse(KafkaDeadLetterQueue.getMirrorSerializer(keyDeserializer)));
        deadQueueProducerConfig.put("value.serializer", conf.getDeadLetterQueueValueSerializer().orElse(KafkaDeadLetterQueue.getMirrorSerializer(valueDeserializer)));
        deadQueueProducerConfig.put("client.id", "kafka-dead-letter-topic-producer-" + conf.getChannel());
        ConfigurationCleaner.cleanupProducerConfiguration(deadQueueProducerConfig);
        String deadQueueTopic = conf.getDeadLetterQueueTopic().orElse("dead-letter-topic-" + conf.getChannel());
        KafkaLogging.log.deadLetterConfig(deadQueueTopic, (String)deadQueueProducerConfig.get("key.serializer"), (String)deadQueueProducerConfig.get("value.serializer"));
        ReactiveKafkaProducer producer = new ReactiveKafkaProducer(deadQueueProducerConfig, deadQueueTopic, 10000, null, null);
        kafkaCDIEvents.producer().fire(producer.unwrap());
        return new KafkaDeadLetterQueue(conf.getChannel(), deadQueueTopic, producer, source);
    }

    private static String getMirrorSerializer(String deserializer) {
        if (deserializer == null) {
            return StringSerializer.class.getName();
        }
        return deserializer.replace("Deserializer", "Serializer");
    }

    private String getThrowableMessage(Throwable throwable) {
        String text = throwable.getMessage();
        if (text == null) {
            text = throwable.toString();
        }
        return text;
    }

    @Override
    public <K, V> CompletionStage<Void> handle(IncomingKafkaRecord<K, V> record, Throwable reason, Metadata metadata) {
        OutgoingKafkaRecordMetadata outgoing = metadata != null ? (OutgoingKafkaRecordMetadata)metadata.get(OutgoingKafkaRecordMetadata.class).orElse(null) : null;
        String topic = this.topic;
        if (outgoing != null && outgoing.getTopic() != null) {
            topic = outgoing.getTopic();
        }
        Object key = record.getKey();
        if (outgoing != null && outgoing.getKey() != null) {
            key = outgoing.getKey();
        }
        Integer partition = null;
        if (outgoing != null && outgoing.getPartition() >= 0) {
            partition = outgoing.getPartition();
        }
        ProducerRecord dead = new ProducerRecord(topic, partition, key, record.getPayload());
        this.addHeader(dead, DEAD_LETTER_REASON, this.getThrowableMessage(reason));
        if (reason.getCause() != null) {
            this.addHeader(dead, DEAD_LETTER_CAUSE, this.getThrowableMessage(reason.getCause()));
        }
        this.addHeader(dead, DEAD_LETTER_TOPIC, record.getTopic());
        this.addHeader(dead, DEAD_LETTER_PARTITION, Integer.toString(record.getPartition()));
        this.addHeader(dead, DEAD_LETTER_OFFSET, Long.toString(record.getOffset()));
        record.getHeaders().forEach(header -> dead.headers().add(header));
        if (outgoing != null && outgoing.getHeaders() != null) {
            outgoing.getHeaders().forEach(header -> dead.headers().add(header));
        }
        KafkaLogging.log.messageNackedDeadLetter(this.channel, topic);
        return this.producer.send(dead).onFailure().invoke(t -> this.source.reportFailure((Throwable)t, true)).onItem().ignore().andContinueWithNull().subscribeAsCompletionStage().thenCompose(m -> record.ack());
    }

    void addHeader(ProducerRecord<?, ?> record, String key, String value) {
        record.headers().add(key, value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void terminate() {
        this.producer.close();
    }
}

