/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    DATA_SOURCE("data-source"),
    NAME("name"),
    VALUE("value"),
    EXECUTION_RECORDS_LIMIT("execution-records-limit");

    private static final Map<String, Attribute> MAP;
    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        if (localName == null) {
            return UNKNOWN;
        }
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        map.put(Attribute.DATA_SOURCE.name, DATA_SOURCE);
        map.put(Attribute.NAME.name, NAME);
        map.put(Attribute.VALUE.name, VALUE);
        map.put(Attribute.EXECUTION_RECORDS_LIMIT.name, EXECUTION_RECORDS_LIMIT);
        MAP = Collections.unmodifiableMap(map);
    }
}

