/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.core.embedded.Context;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

class ChainedContext
implements Context {
    private final List<Context> contexts = new ArrayList<Context>();

    ChainedContext() {
    }

    void add(Context context) {
        this.contexts.add(context);
    }

    @Override
    public void activate() {
        for (Context context : this.contexts) {
            context.activate();
        }
    }

    @Override
    public void restore() {
        for (int i = this.contexts.size() - 1; i >= 0; --i) {
            Context context = this.contexts.get(i);
            try {
                context.restore();
                continue;
            }
            catch (Exception e) {
                EmbeddedLogger.ROOT_LOGGER.failedToRestoreContext(e, context);
            }
        }
    }
}

